/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.domains.operator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.quadcom.datapack.common.ISpike;
import ru.quadcom.datapack.common.StatsMath;
import ru.quadcom.datapack.domains.BaseVariable;
import ru.quadcom.datapack.domains.operator.UnitTraitType;
import ru.quadcom.datapack.templates.common.UnitSkinColor;
import ru.quadcom.datapack.templates.common.UnitSkinPart;
import ru.quadcom.datapack.templates.operator.ClassTemplate;

public class Operator
implements ISpike {
    private long id;
    private long profileId;
    private String name;
    private int nationalityId;
    private int genderId;
    private int raceId;
    private int rarityId;
    private int rankId;
    private long experience;
    private int strength;
    private int perception;
    private int intelligence;
    private int knack;
    private int endurance;
    private int strengthActionCounter;
    private int perceptionActionCounter;
    private int intelligenceActionCounter;
    private int knackActionCounter;
    private int enduranceActionCounter;
    private List<Integer> classIds = Lists.newArrayList();
    private String avatarName;
    private Map<String, Integer> avatarLayers = Maps.newHashMap();
    private int place;
    private List<UnitSkinPart> skinParts;
    private int skillPoints;
    private UnitSkinColor skinColors;
    private int needHealingHP;
    private long startTimeHealingHP;
    private Set<UnitTraitType> traits = Sets.newHashSet();

    public Set<UnitTraitType> getTraits() {
        return Collections.unmodifiableSet(this.traits);
    }

    public void addAllTraits(Collection<UnitTraitType> traits) {
        this.traits.addAll(traits);
    }

    public void addTrait(UnitTraitType trait) {
        this.traits.add(trait);
    }

    public int getNeedHealingHP() {
        return this.needHealingHP;
    }

    public void setNeedHealingHP(int needHealingHP) {
        this.needHealingHP = needHealingHP;
    }

    public long getStartTimeHealingHP() {
        return this.startTimeHealingHP;
    }

    public void setStartTimeHealingHP(long startTimeHealingHP) {
        this.startTimeHealingHP = startTimeHealingHP;
    }

    public UnitSkinColor getSkinColors() {
        return this.skinColors;
    }

    public void setSkinColors(UnitSkinColor skinColors) {
        this.skinColors = skinColors;
    }

    public int getSkillPoints() {
        return this.skillPoints;
    }

    public void setSkillPoints(int skillPoints) {
        this.skillPoints = skillPoints;
    }

    public List<UnitSkinPart> getSkinParts() {
        return this.skinParts;
    }

    public void setSkinParts(List<UnitSkinPart> skinParts) {
        this.skinParts = skinParts;
    }

    public int getNationalityId() {
        return this.nationalityId;
    }

    public void setNationalityId(int nationalityId) {
        this.nationalityId = nationalityId;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getProfileId() {
        return this.profileId;
    }

    public void setProfileId(long profileId) {
        this.profileId = profileId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getGenderId() {
        return this.genderId;
    }

    public void setGenderId(int genderId) {
        this.genderId = genderId;
    }

    public int getRaceId() {
        return this.raceId;
    }

    public void setRaceId(int raceId) {
        this.raceId = raceId;
    }

    public int getRarityId() {
        return this.rarityId;
    }

    public void setRarityId(int rarityId) {
        this.rarityId = rarityId;
    }

    public int getRankId() {
        return this.rankId;
    }

    public void setRankId(int rankId) {
        this.rankId = rankId;
    }

    public long getExperience() {
        return this.experience;
    }

    public void setExperience(long experience) {
        this.experience = experience;
    }

    @Override
    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    @Override
    public int getPerception() {
        return this.perception;
    }

    public void setPerception(int perception) {
        this.perception = perception;
    }

    @Override
    public int getIntelligence() {
        return this.intelligence;
    }

    public void setIntelligence(int intelligence) {
        this.intelligence = intelligence;
    }

    @Override
    public int getKnack() {
        return this.knack;
    }

    public void setKnack(int knack) {
        this.knack = knack;
    }

    @Override
    public int getEndurance() {
        return this.endurance;
    }

    public void setEndurance(int endurance) {
        this.endurance = endurance;
    }

    public int getStrengthActionCounter() {
        return this.strengthActionCounter;
    }

    public void setStrengthActionCounter(int strengthActionCounter) {
        this.strengthActionCounter = strengthActionCounter;
    }

    public int getPerceptionActionCounter() {
        return this.perceptionActionCounter;
    }

    public void setPerceptionActionCounter(int perceptionActionCounter) {
        this.perceptionActionCounter = perceptionActionCounter;
    }

    public int getIntelligenceActionCounter() {
        return this.intelligenceActionCounter;
    }

    public void setIntelligenceActionCounter(int intelligenceActionCounter) {
        this.intelligenceActionCounter = intelligenceActionCounter;
    }

    public int getKnackActionCounter() {
        return this.knackActionCounter;
    }

    public void setKnackActionCounter(int knackActionCounter) {
        this.knackActionCounter = knackActionCounter;
    }

    public int getEnduranceActionCounter() {
        return this.enduranceActionCounter;
    }

    public void setEnduranceActionCounter(int enduranceActionCounter) {
        this.enduranceActionCounter = enduranceActionCounter;
    }

    public Collection<Integer> getClassIds() {
        return Collections.unmodifiableCollection(this.classIds);
    }

    public boolean existsClass(ClassTemplate template) {
        return this.classIds.contains(template.getId());
    }

    public void addClass(ClassTemplate classTemplate) {
        this.classIds.add(classTemplate.getId());
    }

    public boolean addClasses(List<Integer> classIds) {
        return this.classIds.addAll(classIds);
    }

    public Map<String, Integer> getAvatarLayers() {
        return Collections.unmodifiableMap(this.avatarLayers);
    }

    public void addAvatarLayers(Map<String, Integer> avatarLayers) {
        this.avatarLayers.putAll(avatarLayers);
    }

    public int getPlace() {
        return this.place;
    }

    public void setPlace(int place) {
        this.place = place;
    }

    public String getAvatarName() {
        return this.avatarName;
    }

    public void setAvatarName(String avatarName) {
        this.avatarName = avatarName;
    }

    public int getCurrentHp() {
        return Math.min(StatsMath.calcHp(this), StatsMath.calcHp(this) - this.getNeedHealingHP() + (int)((Instant.now().toEpochMilli() - this.startTimeHealingHP) / (long)BaseVariable.HEAL_TIME.getInt()));
    }
}

