/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.common;

import ru.quadcom.datapack.common.ISpike;
import ru.quadcom.datapack.domains.BaseVariable;

public class StatsMath {
    public static int calcHp(ISpike spike) {
        return BaseVariable.MC_HP.applyMultiple(BaseVariable.BASE_HP.applyAdditive(BaseVariable.SM_HP.applyMultiple(spike.getStrength())));
    }

    public static int calcSpeed(ISpike spike) {
        return BaseVariable.MC_SPEED.applyMultiple(BaseVariable.BASE_SPEED.applyAdditive(BaseVariable.SM_SPEED.applyMultiple(0)));
    }

    public static double calcHitChanceBonus(ISpike spike) {
        return (double)BaseVariable.MC_HIT_CHANCE.applyMultiple(BaseVariable.SM_HIT_CHANCE_BONUS.applyMultiple(spike.getPerception())) / 100.0;
    }

    public static int calcVisibilityRadius(ISpike spike) {
        return BaseVariable.MC_VISIBILITY_RADIUS.applyMultiple(BaseVariable.BASE_VISIBILITY_RADIUS.applyAdditive(BaseVariable.SM_VISIBILITY_RADIUS.applyMultiple(0)));
    }

    public static int calcDetectionRadius(ISpike spike) {
        return BaseVariable.MC_DETECTION_RADIUS.applyMultiple(BaseVariable.BASE_DETECTION_RADIUS.applyAdditive(BaseVariable.SM_DETECTION_RADIUS.applyMultiple(spike.getPerception())));
    }

    public static int calcStealthRadius(ISpike spike) {
        return BaseVariable.MC_STEALTH_RADIUS.applyMultiple(BaseVariable.BASE_STEALTH_RADIUS.applyAdditive(BaseVariable.SM_STEALTH_RADIUS.applyMultiple(0)));
    }

    public static double calcCritChance(ISpike spike) {
        return (double)BaseVariable.MC_CRITICAL_CHANCE.applyMultiple(BaseVariable.SM_CRITICAL_CHANCE.applyMultiple(spike.getIntelligence())) / 100.0;
    }

    public static double calcFortitude(ISpike spike) {
        return (double)BaseVariable.MC_FORTITUDE.applyMultiple(BaseVariable.BASE_FORTITUDE.applyAdditive(BaseVariable.SM_FORTITUDE.applyMultiple(spike.getKnack()))) / 100.0;
    }

    public static double calcDodge(ISpike spike) {
        return (double)BaseVariable.MC_DODGE.applyMultiple(BaseVariable.BASE_DODGE.applyAdditive(BaseVariable.SM_DODGE.applyMultiple(spike.getKnack()))) / 100.0;
    }

    public static int calcThrowRange(ISpike spike) {
        return BaseVariable.MC_THROW_RANGE.applyMultiple(BaseVariable.BASE_THROW_RANGE.applyAdditive(BaseVariable.SM_THROW_RANGE.applyMultiple(spike.getStrength())));
    }

    public static int calcArmorBonus(ISpike spike) {
        return BaseVariable.MC_ARMOR_BONUS.applyMultiple(BaseVariable.BASE_ARMOR_BONUS.applyAdditive(BaseVariable.SM_ARMOR_BONUS.applyMultiple(spike.getKnack())));
    }
}

