/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import ru.quadcom.datapack.domains.item.ItemActionType;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.loaders.impl.ItemActionsLoader;
import ru.quadcom.datapack.loaders.impl.ItemPropertiesLoader;
import ru.quadcom.datapack.loaders.impl.ItemsLoader;
import ru.quadcom.datapack.loaders.impl.LootDropLoader;
import ru.quadcom.datapack.loaders.impl.LootWeightLoader;
import ru.quadcom.datapack.services.IItemPack;
import ru.quadcom.datapack.templates.item.ItemActionTemplate;
import ru.quadcom.datapack.templates.item.ItemPropertyTemplate;
import ru.quadcom.datapack.templates.item.ItemTemplate;

public class ItemPack
implements IItemPack {
    private String prefix = "";
    private Map<Integer, ItemTemplate> itemTemplates;
    private Map<Integer, ItemTemplate> skillTemplates;
    private Map<ItemActionType, ItemActionTemplate> itemActionTemplates;
    private Map<Integer, ItemPropertyTemplate> itemPropertyTemplates;
    private Map<String, Map<Integer, NavigableMap<Double, ItemType>>> lootDrops;
    private Map<ItemType, Map<Integer, NavigableMap<Double, Integer>>> lootWeights;

    ItemPack(String resourceUrl) {
        this.itemTemplates = new ItemsLoader(resourceUrl, this.prefix).load("items.json");
        this.itemActionTemplates = new ItemActionsLoader(resourceUrl, this.prefix).load("item_actions.json");
        this.itemPropertyTemplates = new ItemPropertiesLoader(resourceUrl, this.prefix).load("item_properties.json");
        this.skillTemplates = new ItemsLoader(resourceUrl, this.prefix).load("skills.json");
        this.lootDrops = new LootDropLoader(resourceUrl, this.prefix).load("loot_drops.json");
        this.lootWeights = new LootWeightLoader(resourceUrl, this.prefix, this.itemTemplates).load("loot_weights.json");
        this.preProcessItemTemplates();
    }

    @Override
    public List<ItemTemplate> getItemTemplates() {
        return Lists.newArrayList(this.itemTemplates.values());
    }

    @Override
    public ItemTemplate getItemTemplate(int itemTemplateId) {
        return this.itemTemplates.get(itemTemplateId);
    }

    @Override
    public ItemTemplate getSkillTemplate(int skillTemplateId) {
        return this.skillTemplates.get(skillTemplateId);
    }

    @Override
    public List<ItemTemplate> getSkills() {
        return Lists.newArrayList(this.skillTemplates.values());
    }

    @Override
    public ItemActionTemplate getItemActionTemplate(ItemActionType itemActionType) {
        return this.itemActionTemplates.get((Object)itemActionType);
    }

    @Override
    public ItemPropertyTemplate getItemPropertyTemplate(int itemPropertyTemplateId) {
        return this.itemPropertyTemplates.get(itemPropertyTemplateId);
    }

    @Override
    public List<ItemTemplate> generateDrop(String dropListName, int rank, int count) {
        ArrayList drop = Lists.newArrayList();
        for (int i = 0; i < count; ++i) {
            ItemTemplate itemTemplate;
            ItemType itemType;
            NavigableMap<Double, Integer> map2;
            Double key2;
            NavigableMap<Double, ItemType> map = this.lootDrops.getOrDefault(dropListName, Maps.newHashMap()).getOrDefault(rank, Maps.newTreeMap());
            Double key = map.ceilingKey(Math.random() * 100.0);
            if (key == null || (key2 = (map2 = this.lootWeights.getOrDefault((Object)(itemType = (ItemType)((Object)map.get(key))), Maps.newHashMap()).getOrDefault(rank, Maps.newTreeMap())).ceilingKey(Math.random() * 100.0)) == null || (itemTemplate = this.itemTemplates.get(map2.get(key2))) == null) continue;
            drop.add(itemTemplate);
        }
        return drop;
    }

    private void preProcessItemTemplates() {
        for (ItemTemplate itemTemplate : this.itemTemplates.values()) {
            itemTemplate.preProcess();
        }
        for (ItemTemplate itemTemplate : this.skillTemplates.values()) {
            itemTemplate.preProcess();
        }
    }
}

