/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.common.EnumUtil;
import ru.quadcom.datapack.common.RandomValueProvider;
import ru.quadcom.datapack.domains.MissionResult;
import ru.quadcom.datapack.domains.MoneyReward;
import ru.quadcom.datapack.domains.item.ItemActionType;
import ru.quadcom.datapack.domains.item.ItemClass;
import ru.quadcom.datapack.domains.item.ItemTemplatePropertyName;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.domains.item.ProgressItem;
import ru.quadcom.datapack.loaders.impl.EquipmentLevelsLoader;
import ru.quadcom.datapack.loaders.impl.ItemActionsLoader;
import ru.quadcom.datapack.loaders.impl.ItemPartsLoader;
import ru.quadcom.datapack.loaders.impl.ItemProgressLoader;
import ru.quadcom.datapack.loaders.impl.ItemPropertiesLoader;
import ru.quadcom.datapack.loaders.impl.ItemsLoader;
import ru.quadcom.datapack.loaders.impl.LootBoxSlotGroupLoader;
import ru.quadcom.datapack.loaders.impl.LootBoxSlotItemLoader;
import ru.quadcom.datapack.loaders.impl.LootDrop2Loader;
import ru.quadcom.datapack.loaders.impl.LootWeightLoader;
import ru.quadcom.datapack.loaders.impl.MoneyRewardLoader;
import ru.quadcom.datapack.loaders.impl.SkillLoader;
import ru.quadcom.datapack.services.IItemPack;
import ru.quadcom.datapack.templates.item.ItemActionTemplate;
import ru.quadcom.datapack.templates.item.ItemPropertyTemplate;
import ru.quadcom.datapack.templates.item.ItemTemplate;
import ru.quadcom.datapack.templates.item.SkillTemplate;
import ru.quadcom.datapack.templates.item.upgrade.DisassembleConfigItem;
import ru.quadcom.datapack.templates.item.upgrade.EquipmentLevelItem;
import ru.quadcom.datapack.templates.lootbox.LootBoxSlotGroup;
import ru.quadcom.datapack.templates.lootbox.LootBoxSlotItem;
import ru.quadcom.exceptions.ErrorException;

public class ItemPack
implements IItemPack {
    private String prefix = "";
    private final Map<Integer, ItemTemplate> itemTemplates;
    private final Map<ItemClass, List<ItemTemplate>> itemTemplateListByItemClass;
    private final Map<Integer, SkillTemplate> skillTemplates;
    private final Map<String, SkillTemplate> skillTemplatesByDescriptor;
    private final Map<ItemActionType, ItemActionTemplate> itemActionTemplates;
    private final Map<Integer, ItemPropertyTemplate> itemPropertyTemplates;
    private final Map<String, Map<Boolean, Map<Integer, Map<Double, ItemType>>>> lootDrops;
    private final Map<ItemType, Map<Integer, RandomValueProvider<ItemTemplate>>> lootWeights;
    private final Map<Integer, ItemTemplate> ammo;
    private final Map<Integer, List<ItemTemplate>> camouflagesByFractionId = new HashMap<Integer, List<ItemTemplate>>();
    private final Map<Integer, List<ItemTemplate>> operatorAvatarsPreparedByFractionId = new HashMap<Integer, List<ItemTemplate>>();
    private final Map<Integer, List<ItemTemplate>> skinsForItemsByFractionId = new HashMap<Integer, List<ItemTemplate>>();
    private final Map<String, Map<MissionResult, Map<Integer, MoneyReward>>> moneyResults;
    private final Map<String, List<LootBoxSlotItem>> lootBoxSlotItemsBySlotId;
    private final Map<String, List<LootBoxSlotGroup>> lootBoxSlotGroupsById;
    private final Map<String, List<DisassembleConfigItem>> itemPartsByGroupId;
    private final Map<String, List<EquipmentLevelItem>> equipmentLevelsByGroupId;
    private final Map<Integer, ProgressItem> progressItemMap;
    private final Map<String, List<ProgressItem>> progressItemMapByListId;

    ItemPack(String resourceUrl) {
        this.itemTemplates = new ItemsLoader(resourceUrl, this.prefix).load("items.json");
        this.itemTemplateListByItemClass = this.itemTemplates.values().stream().collect(Collectors.groupingBy(ItemTemplate::getItemClass));
        this.itemActionTemplates = new ItemActionsLoader(resourceUrl, this.prefix).load("item_actions.json");
        this.itemPropertyTemplates = new ItemPropertiesLoader(resourceUrl, this.prefix).load("item_properties.json");
        this.skillTemplates = new SkillLoader(resourceUrl, this.prefix).load("skills.json");
        this.skillTemplatesByDescriptor = this.skillTemplates.values().stream().collect(Collectors.toMap(template -> template.getDescriptor().toLowerCase(), Function.identity()));
        this.lootDrops = new LootDrop2Loader(resourceUrl, this.prefix).load("loot_drops.json");
        this.lootWeights = new LootWeightLoader(resourceUrl, this.prefix, this.itemTemplates).load("loot_weights.json");
        this.ammo = ((StreamEx)StreamEx.of(this.itemTemplates.values()).filter(template -> template.getItemType() == ItemType.AMMO)).toMap(ItemTemplate::getId, template -> template);
        this.moneyResults = new MoneyRewardLoader(resourceUrl, this.prefix).load("money_rewards.json");
        this.preProcessItemTemplates();
        this.buildItemsMapByFractionId(ItemType.CAMOUFLAGE, this.camouflagesByFractionId);
        this.buildItemsMapByFractionId(ItemType.OPERATOR_AVATAR, this.operatorAvatarsPreparedByFractionId);
        this.buildItemsMapByFractionId(ItemType.SKIN_FOR_ITEM, this.skinsForItemsByFractionId);
        this.lootBoxSlotItemsBySlotId = new LootBoxSlotItemLoader(resourceUrl, this.prefix).load("lootbox_slot_items.json");
        this.lootBoxSlotGroupsById = new LootBoxSlotGroupLoader(resourceUrl, this.prefix).load("lootbox_slot_groups.json");
        this.itemPartsByGroupId = new ItemPartsLoader(resourceUrl, this.prefix).load("item_parts.json");
        this.equipmentLevelsByGroupId = new EquipmentLevelsLoader(resourceUrl, this.prefix).load("equipment_levels.json");
        this.progressItemMap = new ItemProgressLoader(resourceUrl, this.prefix).load("item_progress.json");
        this.progressItemMapByListId = StreamEx.of(this.progressItemMap.values()).groupingBy(ProgressItem::getListId);
    }

    @Override
    public List<ItemTemplate> getItemTemplatesByClass(ItemClass itemClass) {
        return this.itemTemplateListByItemClass.getOrDefault((Object)itemClass, Collections.emptyList());
    }

    private void buildItemsMapByFractionId(ItemType itemType, Map<Integer, List<ItemTemplate>> resultMap) {
        for (ItemTemplate template : this.itemTemplates.values()) {
            String[] shopFractionIdsAvailableList;
            if (template.getItemType() != itemType) continue;
            String shopFractionIdsAvailableString = template.getStringItemTemplateProperty(ItemTemplatePropertyName.shopFractionIdsAvailable);
            for (String fractionIdString : shopFractionIdsAvailableList = shopFractionIdsAvailableString.split(",")) {
                int fractionId = Integer.parseInt(fractionIdString);
                List templateList = resultMap.computeIfAbsent(fractionId, x -> new ArrayList());
                templateList.add(template);
            }
        }
    }

    @Override
    public Optional<MoneyReward> getMoneyRewardObject(String rewardName, MissionResult missionResult, int rank) {
        return Optional.ofNullable(this.moneyResults.getOrDefault(rewardName, Maps.newHashMap()).getOrDefault((Object)missionResult, Maps.newHashMap()).get(rank));
    }

    @Override
    public int getMoneyReward(String rewardName, MissionResult missionResult, int rank) {
        return this.getMoneyRewardObject(rewardName, missionResult, rank).map(MoneyReward::getMoneyValue).orElse(0);
    }

    @Override
    public Optional<ItemTemplate> getDefaultAmmo(ItemTemplate weapon) {
        if (weapon.getItemType() != ItemType.WEAPON) {
            throw new ErrorException("Wrong item type " + (Object)((Object)weapon.getItemType()));
        }
        return ((StreamEx)((StreamEx)((StreamEx)StreamEx.of(this.ammo.values()).filter(template -> template.getBooleanItemTemplateProperty(ItemTemplatePropertyName.defaultammo))).filter(template -> template.getBooleanItemTemplateProperty(ItemTemplatePropertyName.batterytype) == weapon.getBooleanItemTemplateProperty(ItemTemplatePropertyName.rayweapon))).filter(template -> {
            if (weapon.getBooleanItemTemplateProperty(ItemTemplatePropertyName.rayweapon)) {
                return true;
            }
            String weapontype = template.getStringItemTemplateProperty(ItemTemplatePropertyName.weapontype);
            return Strings.isNullOrEmpty((String)weapontype) || EnumUtil.lookup(ItemClass.class, weapontype) == weapon.getItemClass();
        })).findFirst();
    }

    @Override
    public List<ItemTemplate> getItemTemplates() {
        return Lists.newArrayList(this.itemTemplates.values());
    }

    @Override
    public Optional<ItemTemplate> getItemTemplateOptional(int itemTemplateId) {
        return Optional.ofNullable(this.itemTemplates.get(itemTemplateId));
    }

    @Override
    public ItemTemplate getItemTemplate(int id) {
        ItemTemplate template = this.itemTemplates.get(id);
        if (template == null) {
            throw new ErrorException("not fount template for item with id = " + id);
        }
        return template;
    }

    @Override
    public SkillTemplate getSkillTemplate(String descriptor) {
        SkillTemplate template = this.skillTemplatesByDescriptor.get(descriptor.toLowerCase());
        if (template == null) {
            throw new ErrorException("not fount template for skill with descriptor=" + descriptor);
        }
        return template;
    }

    @Override
    public SkillTemplate getSkillTemplate(int id) {
        SkillTemplate template = this.skillTemplates.get(id);
        if (template == null) {
            throw new ErrorException("not fount template for skill with id = " + id);
        }
        return template;
    }

    @Override
    public Optional<SkillTemplate> getSkillTemplateOptional(int skillTemplateId) {
        return Optional.ofNullable(this.skillTemplates.get(skillTemplateId));
    }

    @Override
    public List<SkillTemplate> getSkills() {
        return Lists.newArrayList(this.skillTemplates.values());
    }

    @Override
    public List<ItemTemplate> getCamouflagesByFractionId(int fractionId) {
        return Lists.newArrayList((Iterable)this.camouflagesByFractionId.get(fractionId));
    }

    @Override
    public List<ItemTemplate> getOperatorAvatarsPreparedByFractionId(int fractionId) {
        return Lists.newArrayList((Iterable)this.operatorAvatarsPreparedByFractionId.getOrDefault(fractionId, Collections.emptyList()));
    }

    @Override
    public List<ItemTemplate> getSkinsForItemsByFractionId(int fractionId) {
        return Lists.newArrayList((Iterable)this.skinsForItemsByFractionId.getOrDefault(fractionId, Collections.emptyList()));
    }

    @Override
    public ItemActionTemplate getItemActionTemplate(ItemActionType itemActionType) {
        return this.itemActionTemplates.get((Object)itemActionType);
    }

    @Override
    public ItemPropertyTemplate getItemPropertyTemplate(int itemPropertyTemplateId) {
        return this.itemPropertyTemplates.get(itemPropertyTemplateId);
    }

    @Override
    public List<ItemTemplate> generateDrop(String dropListName, boolean win, int rank, int count, Map<ItemType, Double> addGroupChances) {
        ArrayList drop = Lists.newArrayList();
        for (int i = 0; i < count; ++i) {
            Map map = this.lootDrops.getOrDefault(dropListName, Collections.emptyMap()).getOrDefault(win, Collections.emptyMap()).getOrDefault(rank, Collections.emptyMap());
            for (Map.Entry entry : map.entrySet()) {
                double addChance = addGroupChances.getOrDefault(entry.getValue(), 0.0);
                if (!((Double)entry.getKey() + addChance > ThreadLocalRandom.current().nextDouble())) continue;
                this.lootWeights.getOrDefault(entry.getValue(), Collections.emptyMap()).getOrDefault(rank, RandomValueProvider.empty()).nextRandom().ifPresent(drop::add);
            }
        }
        return drop;
    }

    @Override
    public List<LootBoxSlotItem> getLootBoxSlotItemsBySlotId(String slotId) {
        return this.lootBoxSlotItemsBySlotId.get(slotId);
    }

    @Override
    public List<LootBoxSlotGroup> getLootBoxSlotGroupsById(String groupId) {
        return this.lootBoxSlotGroupsById.get(groupId);
    }

    @Override
    public List<DisassembleConfigItem> getItemPartsByGroupId(String groupId) {
        return this.itemPartsByGroupId.get(groupId);
    }

    @Override
    public List<EquipmentLevelItem> getEquipmentLevelsByGroupId(String groupId) {
        return this.equipmentLevelsByGroupId.get(groupId);
    }

    @Override
    public ProgressItem getProgressItem(int progressItemId) {
        return this.progressItemMap.get(progressItemId);
    }

    @Override
    public List<ProgressItem> getProgressItemList(String listId) {
        return this.progressItemMapByListId.get(listId);
    }

    private void preProcessItemTemplates() {
        for (ItemTemplate itemTemplate : this.itemTemplates.values()) {
            itemTemplate.preProcess();
        }
        for (ItemTemplate itemTemplate : this.skillTemplates.values()) {
            itemTemplate.preProcess();
        }
    }
}

