/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.loaders.impl;

import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.loaders.Loader;
import ru.quadcom.datapack.templates.common.LootDrop;

public class LootDrop2Loader
extends Loader<LootDrop> {
    public LootDrop2Loader(String resourceUrl, String prefix) {
        super(resourceUrl, prefix);
    }

    @Override
    protected Type getType() {
        return new TypeToken<List<LootDrop>>(){}.getType();
    }

    @Override
    public Map<String, Map<Boolean, Map<Integer, Map<Double, ItemType>>>> load(String fileName) {
        List lootDrops = StreamEx.of(this.load0(fileName)).toList();
        HashMap map = Maps.newHashMap();
        for (LootDrop lootDrop : lootDrops) {
            map.compute(lootDrop.getDropListName(), (key2, map2) -> {
                if (map2 == null) {
                    map2 = Maps.newHashMap();
                }
                map2.compute(lootDrop.isWin(), (key3, map3) -> {
                    if (map3 == null) {
                        map3 = Maps.newHashMap();
                    }
                    map3.computeIfAbsent(lootDrop.getRank(), key4 -> {
                        TreeMap map4 = Maps.newTreeMap();
                        map4.putIfAbsent(lootDrop.getWeapon(), ItemType.WEAPON);
                        map4.putIfAbsent(lootDrop.getArmor(), ItemType.ARMOR);
                        map4.putIfAbsent(lootDrop.getGrenade(), ItemType.GRENADE);
                        map4.putIfAbsent(lootDrop.getFirstAid(), ItemType.FIRST_AID);
                        map4.putIfAbsent(lootDrop.getMine(), ItemType.MINE);
                        map4.putIfAbsent(lootDrop.getScanner(), ItemType.SCANNER);
                        map4.putIfAbsent(lootDrop.getGadget(), ItemType.GADGET);
                        map4.putIfAbsent(lootDrop.getAmmo(), ItemType.AMMO);
                        map4.putIfAbsent(lootDrop.getRepairKit(), ItemType.REPAIR_KIT);
                        map4.putIfAbsent(lootDrop.getUpgradeWeapon(), ItemType.UPGRADE_WEAPON);
                        map4.putIfAbsent(lootDrop.getUpgradeArmor(), ItemType.UPGRADE_ARMOR);
                        map4.putIfAbsent(lootDrop.getBox(), ItemType.LOOTBOX);
                        map4.putIfAbsent(lootDrop.getKey(), ItemType.KEY);
                        map4.putIfAbsent(lootDrop.getTrash(), ItemType.TRASH);
                        return map4;
                    });
                    return map3;
                });
                return map2;
            });
        }
        return map;
    }
}

