/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.loaders.impl;

import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.common.RandomValueProvider;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.loaders.Loader;
import ru.quadcom.datapack.templates.shop.ItemSpecialShopWeight;

public class ItemSpecialShopWeightLoader
extends Loader<ItemSpecialShopWeight> {
    private static final int LEVEL_3 = 3;
    private static final int LEVEL_10 = 10;
    private static final int LEVEL_20 = 20;
    private static final int LEVEL_30 = 30;

    public ItemSpecialShopWeightLoader(String resourceUrl) {
        super(resourceUrl);
    }

    @Override
    protected Type getType() {
        return new TypeToken<List<ItemSpecialShopWeight>>(){}.getType();
    }

    @Override
    public Map<ItemType, NavigableMap<Integer, RandomValueProvider<ItemSpecialShopWeight>>> load(String fileName) {
        Map temp = StreamEx.of(this.load0(fileName)).groupingBy(ItemSpecialShopWeight::getItemType);
        HashMap map = Maps.newHashMap();
        for (ItemType itemType : temp.keySet()) {
            map.put(itemType, Maps.newTreeMap());
        }
        for (Map.Entry entry : temp.entrySet()) {
            NavigableMap weightsByLevel = (NavigableMap)map.get(entry.getKey());
            weightsByLevel.put(3, RandomValueProvider.forShares());
            weightsByLevel.put(10, RandomValueProvider.forShares());
            weightsByLevel.put(20, RandomValueProvider.forShares());
            weightsByLevel.put(30, RandomValueProvider.forShares());
            for (ItemSpecialShopWeight issw : (List)entry.getValue()) {
                RandomValueProvider provider = (RandomValueProvider)weightsByLevel.get(3);
                provider.add(issw, issw.getaLevel3());
                provider = (RandomValueProvider)weightsByLevel.get(10);
                provider.add(issw, issw.getaLevel10());
                provider = (RandomValueProvider)weightsByLevel.get(20);
                provider.add(issw, issw.getaLevel20());
                provider = (RandomValueProvider)weightsByLevel.get(30);
                provider.add(issw, issw.getaLevel30());
            }
        }
        return map;
    }
}

