/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.domains.item;

import java.util.List;
import ru.quadcom.datapack.domains.BaseVariable;
import ru.quadcom.datapack.domains.item.Attached;
import ru.quadcom.datapack.domains.item.Item;
import ru.quadcom.datapack.domains.item.ItemTemplatePropertyName;
import ru.quadcom.datapack.services.IDataPack;
import ru.quadcom.datapack.templates.item.ItemTemplate;

public class ItemUtils {
    public static long calculateSellPriceOfItemList(List<Item> itemList, IDataPack dataPack) {
        long sum = 0L;
        for (Item item : itemList) {
            sum += ItemUtils.getPrice(dataPack, item.getItemTemplateId()) * (long)item.getCount();
            for (Attached itemAttachment : item.getAttachedItems().values()) {
                sum += ItemUtils.getPrice(dataPack, itemAttachment.getTemplateId());
            }
        }
        return sum;
    }

    private static long getPrice(IDataPack dataPack, int templateId) {
        ItemTemplate template = dataPack.getItemPack().getItemTemplate(templateId);
        int basePrice = template.getIntItemTemplateProperty(ItemTemplatePropertyName.price);
        return (long)((double)basePrice * BaseVariable.SALE_PRICE_MODIFIER.getDouble());
    }
}

