/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.loaders.impl;

import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.common.RandomValueProvider;
import ru.quadcom.datapack.domains.item.ItemType;
import ru.quadcom.datapack.loaders.Loader;
import ru.quadcom.datapack.templates.shop.ItemSpecialShopGroup;

public class ItemSpecialShopGroupLoader
extends Loader<ItemSpecialShopGroup> {
    public ItemSpecialShopGroupLoader(String resourceUrl) {
        super(resourceUrl);
    }

    @Override
    protected Type getType() {
        return new TypeToken<List<ItemSpecialShopGroup>>(){}.getType();
    }

    @Override
    public NavigableMap<Integer, RandomValueProvider<ItemType>> load(String fileName) {
        Map temp = StreamEx.of(this.load0(fileName)).groupingBy(ItemSpecialShopGroup::getAccountLevel);
        TreeMap map = Maps.newTreeMap();
        for (Map.Entry entry : temp.entrySet()) {
            RandomValueProvider<ItemType> provider = RandomValueProvider.forWeights();
            for (ItemSpecialShopGroup issg : (List)entry.getValue()) {
                provider.add(ItemType.WEAPON, issg.getWeapon());
                provider.add(ItemType.ARMOR, issg.getArmor());
                provider.add(ItemType.GRENADE, issg.getGrenade());
                provider.add(ItemType.FIRST_AID, issg.getFirstAidKit());
                provider.add(ItemType.AMMO, issg.getAmmo());
                provider.add(ItemType.UPGRADE_WEAPON, issg.getUpgradeWeapon());
                provider.add(ItemType.UPGRADE_ARMOR, issg.getUpgradeArmor());
            }
            map.put(entry.getKey(), provider);
        }
        return map;
    }
}

