/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.domains.ExperienceConfig;
import ru.quadcom.datapack.domains.RBWinSeriesMultiplierConfig;
import ru.quadcom.datapack.domains.SeasonReward;
import ru.quadcom.datapack.domains.SkillsConfig;
import ru.quadcom.datapack.domains.SpikePointsConfig;
import ru.quadcom.datapack.domains.battleeffects.BattleEffect;
import ru.quadcom.datapack.domains.battleeffects.BattleEffectType;
import ru.quadcom.datapack.domains.profile.ProfileLevel;
import ru.quadcom.datapack.loaders.impl.BaseConstantsLoader;
import ru.quadcom.datapack.loaders.impl.BattleEffectsLoader;
import ru.quadcom.datapack.loaders.impl.DivisionLoader;
import ru.quadcom.datapack.loaders.impl.ExpConfigLoader;
import ru.quadcom.datapack.loaders.impl.GiftBPLoader;
import ru.quadcom.datapack.loaders.impl.GiftItemLoader;
import ru.quadcom.datapack.loaders.impl.GiftMoneyLoader;
import ru.quadcom.datapack.loaders.impl.GiftOperatorLoader;
import ru.quadcom.datapack.loaders.impl.InteractiveObjectsLoader;
import ru.quadcom.datapack.loaders.impl.ItemFractionLoader;
import ru.quadcom.datapack.loaders.impl.MapsLoader;
import ru.quadcom.datapack.loaders.impl.PrefabDestructionLoader;
import ru.quadcom.datapack.loaders.impl.ProfileLevelsLoader;
import ru.quadcom.datapack.loaders.impl.RBMultiplierConfigLoader;
import ru.quadcom.datapack.loaders.impl.SeasonRewardLoader;
import ru.quadcom.datapack.loaders.impl.SkillConfigLoader;
import ru.quadcom.datapack.loaders.impl.SpikePointsConfigLoader;
import ru.quadcom.datapack.services.ICommonPack;
import ru.quadcom.datapack.templates.common.BaseConstantsTemplate;
import ru.quadcom.datapack.templates.common.Division;
import ru.quadcom.datapack.templates.common.DivisionType;
import ru.quadcom.datapack.templates.common.GiftGroup;
import ru.quadcom.datapack.templates.common.GiftItemTemplate;
import ru.quadcom.datapack.templates.common.GiftMoneyTemplate;
import ru.quadcom.datapack.templates.common.GiftOperatorTemplate;
import ru.quadcom.datapack.templates.common.InteractiveObject;
import ru.quadcom.datapack.templates.common.MapTemplate;
import ru.quadcom.datapack.templates.common.PrefabDestructionTemplate;

public class CommonPack
implements ICommonPack {
    private final Map<String, BaseConstantsTemplate> baseConstants;
    private final ExperienceConfig experienceConfig;
    private final SpikePointsConfig spikePointsConfig;
    private final Map<BattleEffectType, BattleEffect> battleEffectsConfig;
    private final SkillsConfig skillsConfig;
    private final Map<Integer, Set<Integer>> itemFraction;
    private final Map<Integer, ProfileLevel> profileLevels;
    private final NavigableMap<Long, ProfileLevel> profileExperience;
    private final Map<Integer, PrefabDestructionTemplate> prefabDestructionTemplates;
    private final Map<String, GiftGroup<GiftItemTemplate>> giftItems;
    private final Map<String, GiftGroup<GiftOperatorTemplate>> giftOperators;
    private final Map<String, GiftGroup<GiftMoneyTemplate>> giftMoney;
    private final Set<String> giftBP;
    private final Map<String, MapTemplate> mapsByGuid;
    private final List<MapTemplate> randomMaps;
    private final Map<DivisionType, Division> divisions;
    private final Map<DivisionType, SeasonReward> seasonRewards;
    private final RBWinSeriesMultiplierConfig rbWinSeriesMultiplierConfig;
    private final Map<String, InteractiveObject> interactiveObjects;
    private final List<InteractiveObject> interactiveObjectList;

    CommonPack(String resourceUrl) {
        String prefix = "";
        this.baseConstants = new BaseConstantsLoader(resourceUrl, prefix).load("base_constants.json");
        this.experienceConfig = (ExperienceConfig)new ExpConfigLoader(resourceUrl, prefix).load("experience_config.json").get(0);
        this.spikePointsConfig = (SpikePointsConfig)new SpikePointsConfigLoader(resourceUrl, prefix).load("spike_points_config.json").get(0);
        this.battleEffectsConfig = new BattleEffectsLoader(resourceUrl, prefix).load("battle_effects.json");
        this.skillsConfig = (SkillsConfig)new SkillConfigLoader(resourceUrl, prefix).load("skills_config.json").get(0);
        this.itemFraction = new ItemFractionLoader(resourceUrl, prefix).load("item_fractions.json");
        this.profileLevels = new ProfileLevelsLoader(resourceUrl, prefix).load("profile_levels.json");
        this.profileExperience = Maps.newTreeMap();
        this.prefabDestructionTemplates = new PrefabDestructionLoader(resourceUrl, prefix).load("prefab_destruction.json");
        for (ProfileLevel profileLevel : (StreamEx)StreamEx.of(this.profileLevels.values()).sorted(Comparator.comparingInt(ProfileLevel::getLevel))) {
            this.profileExperience.put((this.profileExperience.isEmpty() ? 0L : (Long)this.profileExperience.lastKey()) + profileLevel.getExperience(), profileLevel);
        }
        this.giftItems = new GiftItemLoader(resourceUrl, prefix).load("gift_items.json");
        this.giftMoney = new GiftMoneyLoader(resourceUrl, prefix).load("gift_money.json");
        this.giftOperators = new GiftOperatorLoader(resourceUrl, prefix).load("gift_operators.json");
        this.giftBP = new GiftBPLoader(resourceUrl).load("gift_bp.json");
        Object maps = new MapsLoader(resourceUrl, prefix).load("maps.json");
        this.randomMaps = new ArrayList<MapTemplate>();
        this.mapsByGuid = new HashMap<String, MapTemplate>();
        for (MapTemplate mapTemplate : maps.values()) {
            if (mapTemplate.isAllowedForRandom()) {
                this.randomMaps.add(mapTemplate);
            }
            this.mapsByGuid.put(mapTemplate.getGuid(), mapTemplate);
        }
        this.divisions = new DivisionLoader(resourceUrl, prefix).load("divisions.json");
        this.seasonRewards = new SeasonRewardLoader(resourceUrl).load("season_reward.json");
        this.rbWinSeriesMultiplierConfig = (RBWinSeriesMultiplierConfig)new RBMultiplierConfigLoader(resourceUrl, prefix).load("rb_winseries_mult.json").get(0);
        this.interactiveObjects = new InteractiveObjectsLoader(resourceUrl).load("interactive_objects.json");
        this.interactiveObjectList = ImmutableList.copyOf(this.interactiveObjects.values());
    }

    @Override
    public List<InteractiveObject> getInteractiveObjectsOfType(InteractiveObject.Type type) {
        return ((StreamEx)StreamEx.of(this.interactiveObjectList).filter(interactiveObject -> interactiveObject.getType() == type)).toList();
    }

    @Override
    public InteractiveObject getInteractiveObject(String guid) {
        return this.interactiveObjects.get(guid);
    }

    @Override
    public List<Division> getDivisions() {
        return Lists.newArrayList(this.divisions.values());
    }

    @Override
    public Division getDivision(DivisionType type) {
        return this.divisions.get((Object)type);
    }

    @Override
    public SeasonReward getSeasonReward(DivisionType type) {
        return this.seasonRewards.get((Object)type);
    }

    @Override
    public boolean giftExists(String groupId) {
        return this.giftItems.containsKey(groupId) || this.giftOperators.containsKey(groupId) || this.giftMoney.containsKey(groupId) || this.giftBP.contains(groupId);
    }

    @Override
    public List<GiftItemTemplate> getGiftItems(String groupId) {
        GiftGroup<GiftItemTemplate> group = this.giftItems.get(groupId);
        if (group == null) {
            return Lists.newArrayList();
        }
        return ((StreamEx)((StreamEx)StreamEx.of(group.getPositions()).filter(position -> position.getPositionDropRate() > Math.random())).flatMap(position -> StreamEx.of(position.getGifts())).filter(gift -> gift.getDropRate() > Math.random())).toList();
    }

    @Override
    public List<GiftOperatorTemplate> getGiftOperators(String groupId) {
        GiftGroup<GiftOperatorTemplate> group = this.giftOperators.get(groupId);
        if (group == null) {
            return Lists.newArrayList();
        }
        return ((StreamEx)StreamEx.of(group.getPositions()).filter(position -> position.getPositionDropRate() > Math.random())).flatMap(position -> StreamEx.of(position.getGifts())).toList();
    }

    @Override
    public List<GiftMoneyTemplate> getGiftMoney(String groupId) {
        GiftGroup<GiftMoneyTemplate> group = this.giftMoney.get(groupId);
        if (group == null) {
            return Lists.newArrayList();
        }
        return ((StreamEx)StreamEx.of(group.getPositions()).filter(position -> position.getPositionDropRate() > Math.random())).flatMap(position -> StreamEx.of(position.getGifts())).toList();
    }

    @Override
    public boolean getGiftBP(String groupId) {
        return this.giftBP.contains(groupId);
    }

    @Override
    public BaseConstantsTemplate getBaseConstant(String descriptor) {
        return this.baseConstants.get(descriptor);
    }

    @Override
    public ExperienceConfig getExpConfig() {
        return this.experienceConfig;
    }

    @Override
    public SpikePointsConfig getSpikePointsConfig() {
        return this.spikePointsConfig;
    }

    @Override
    public Map<BattleEffectType, BattleEffect> getBattleEffects() {
        return this.battleEffectsConfig;
    }

    @Override
    public SkillsConfig getSkillsConfig() {
        return this.skillsConfig;
    }

    @Override
    public Set<Integer> getItemFractions(int itemTemplateId) {
        return this.itemFraction.getOrDefault(itemTemplateId, Sets.newHashSet());
    }

    @Override
    public Optional<ProfileLevel> getProfileLevelByLevel(int level) {
        return Optional.ofNullable(this.profileLevels.get(level));
    }

    @Override
    public Optional<ProfileLevel> getProfileLevelByExp(long exp) {
        return Optional.ofNullable(this.profileExperience.floorEntry(exp)).map(Map.Entry::getValue);
    }

    @Override
    public PrefabDestructionTemplate getPrefabDestructionTemplate(int groupId) {
        return this.prefabDestructionTemplates.get(groupId);
    }

    @Override
    public List<MapTemplate> getRandomMaps() {
        return this.randomMaps;
    }

    @Override
    public MapTemplate getMapTemplateByMapGuid(String mapGuid) {
        return this.mapsByGuid.get(mapGuid);
    }

    @Override
    public RBWinSeriesMultiplierConfig getRBWinSeriesMultiplierConfig() {
        return this.rbWinSeriesMultiplierConfig;
    }
}

