/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class IntWeightedRandomizer<T> {
    private int sumWeight;
    private List<Integer> weightList;
    private List<T> valueList;
    private final Random random = new Random();

    public IntWeightedRandomizer() {
        this(16);
    }

    public IntWeightedRandomizer(int initialSize) {
        this.sumWeight = 0;
        this.weightList = new ArrayList<Integer>(initialSize);
        this.valueList = new ArrayList<T>(initialSize);
    }

    public IntWeightedRandomizer(IntWeightedRandomizer<T> other) {
        this.sumWeight = other.sumWeight;
        this.weightList = new ArrayList<Integer>(other.weightList);
        this.valueList = new ArrayList<T>(other.valueList);
    }

    public void addChance(int weight, T value) {
        if (weight <= 0 || value == null) {
            throw new IllegalArgumentException();
        }
        this.sumWeight += weight;
        this.weightList.add(weight);
        this.valueList.add(value);
    }

    public boolean removeChance(T value) {
        for (int i = 0; i < this.valueList.size(); ++i) {
            if (!this.valueList.get(i).equals(value)) continue;
            this.valueList.remove(i);
            this.sumWeight -= this.weightList.remove(i).intValue();
            return true;
        }
        return false;
    }

    public T getRandomValue() {
        if (this.weightList.size() == 0) {
            return null;
        }
        int r = this.random.nextInt(this.sumWeight) + 1;
        int tempWeightSum = 0;
        for (int i = 0; i < this.weightList.size(); ++i) {
            if (r > (tempWeightSum += this.weightList.get(i).intValue())) continue;
            return this.valueList.get(i);
        }
        return null;
    }

    public List<T> getAllValues() {
        return new ArrayList<T>(this.valueList);
    }
}

