/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.common.RandomValueProvider;
import ru.quadcom.datapack.loaders.impl.ContractGroupLoader;
import ru.quadcom.datapack.loaders.impl.ContractLoader;
import ru.quadcom.datapack.loaders.impl.ContractWeightLoader;
import ru.quadcom.datapack.loaders.impl.MapGroupLoader;
import ru.quadcom.datapack.loaders.impl.NPCGroupLoader;
import ru.quadcom.datapack.services.IContractPack;
import ru.quadcom.datapack.templates.MapGroup;
import ru.quadcom.datapack.templates.contract.ContractGroup;
import ru.quadcom.datapack.templates.contract.ContractTemplate;
import ru.quadcom.datapack.templates.contract.ContractWeight;
import ru.quadcom.datapack.templates.npc.NpcGroup;

public class ContractPack
implements IContractPack {
    private final String prefix = "";
    private final Map<Integer, ContractTemplate> contracts;
    private final Map<String, ContractTemplate> contractsByDescriptor;
    private final Map<String, List<MapGroup>> mapGroupsByMapGroupId;
    private final Map<String, MapGroup> mapGroupsById;
    private final Map<String, RandomValueProvider<RandomValueProvider<ContractTemplate>>> eventContractRandomValueProvider;
    private final Map<String, List<NpcGroup>> npcGroupByNpcGroupId;
    private final Map<Integer, Set<String>> contractGroupCatalog;

    ContractPack(String resourceUrl) {
        this.contracts = new ContractLoader(resourceUrl, "").load("contracts.json");
        this.contractsByDescriptor = StreamEx.of(this.contracts.values()).toMap(ContractTemplate::getDescriptor, Function.identity());
        this.mapGroupsByMapGroupId = new MapGroupLoader(resourceUrl, "").load("map_groups.json");
        this.mapGroupsById = Maps.newHashMap();
        for (List<MapGroup> list : this.mapGroupsByMapGroupId.values()) {
            for (MapGroup group : list) {
                this.mapGroupsById.put(group.getId(), group);
            }
        }
        Object contractGroups = new ContractGroupLoader(resourceUrl, "").load("contract_groups.json");
        Object contractWeights = new ContractWeightLoader(resourceUrl, "").load("contract_packs.json");
        this.contractGroupCatalog = contractWeights.values().stream().flatMap(Collection::stream).collect(Collectors.groupingBy(ContractWeight::getContractId, Collectors.collectingAndThen(Collectors.toSet(), set -> set.stream().map(ContractWeight::getContractPackId).collect(Collectors.toSet()))));
        Map<String, RandomValueProvider> contractWeightRandomMap = contractWeights.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            List weights = (List)entry.getValue();
            RandomValueProvider<ContractTemplate> randomValueProvider = RandomValueProvider.forWeights();
            for (ContractWeight weight : weights) {
                randomValueProvider.add(this.contracts.get(weight.getContractId()), weight.getWeight());
            }
            return randomValueProvider;
        }));
        this.eventContractRandomValueProvider = contractGroups.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            List groups = (List)entry.getValue();
            RandomValueProvider randomValueProvider = RandomValueProvider.forShares();
            for (ContractGroup group : groups) {
                randomValueProvider.add(contractWeightRandomMap.get(group.getContractPack()), group.getDropChance());
            }
            return randomValueProvider;
        }));
        this.npcGroupByNpcGroupId = new NPCGroupLoader(resourceUrl, "").load("npc_groups.json");
    }

    @Override
    public ContractTemplate getContractTemplate(int contractTemplateId) {
        return this.contracts.get(contractTemplateId);
    }

    @Override
    public ContractTemplate getContractTemplate(String descriptor) {
        return this.contractsByDescriptor.get(descriptor);
    }

    @Override
    public Collection<ContractTemplate> getAll() {
        return Collections.unmodifiableCollection(this.contracts.values());
    }

    @Override
    public Map<Integer, ContractTemplate> getAllAsMap() {
        return Maps.newHashMap(this.contracts);
    }

    @Override
    public List<MapGroup> getMapGroups(String mapGroupId) {
        return this.mapGroupsByMapGroupId.get(mapGroupId);
    }

    @Override
    public MapGroup getMapGroup(String id) {
        return this.mapGroupsById.get(id);
    }

    @Override
    public List<NpcGroup> getNpcGroups(String id) {
        return this.npcGroupByNpcGroupId.get(id);
    }

    @Override
    public Optional<ContractTemplate> getRandomContractTemplateByGroupId(String groupId, Function<ContractTemplate, Boolean> checker) {
        return this.eventContractRandomValueProvider.getOrDefault(groupId, RandomValueProvider.empty()).nextRandom().flatMap(provider -> RandomValueProvider.from(provider, checker).nextRandom());
    }

    @Override
    public boolean contractsInSameGroup(ContractTemplate template1, ContractTemplate template2) {
        Set groups1 = this.contractGroupCatalog.getOrDefault(template1.getId(), Collections.emptySet());
        Set groups2 = this.contractGroupCatalog.getOrDefault(template2.getId(), Collections.emptySet());
        for (String group : groups1) {
            if (!groups2.contains(group)) continue;
            return true;
        }
        return false;
    }
}

