/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import ru.quadcom.datapack.loaders.impl.BuildingEffectsLoader;
import ru.quadcom.datapack.loaders.impl.BuildingsLoader;
import ru.quadcom.datapack.loaders.impl.ResearchesLoader;
import ru.quadcom.datapack.services.IBasePack;
import ru.quadcom.datapack.templates.base.BuildingEffectName;
import ru.quadcom.datapack.templates.base.BuildingTemplate;
import ru.quadcom.datapack.templates.base.BuildingType;
import ru.quadcom.datapack.templates.base.ResearchTemplate;

public class BasePack
implements IBasePack {
    private final Map<BuildingType, Map<Integer, BuildingTemplate>> buildings;
    private final Map<Integer, ResearchTemplate> researches;
    private final Map<BuildingEffectName, Map<Integer, Integer>> buildingEffects;

    BasePack(String resourceUrl) {
        this.buildings = new BuildingsLoader(resourceUrl).load("buildings.json");
        this.researches = new ResearchesLoader(resourceUrl).load("researches.json");
        this.buildingEffects = new BuildingEffectsLoader(resourceUrl).load("building_effects.json");
    }

    @Override
    public BuildingTemplate getBuildingTemplate(BuildingType type, int level) {
        return this.buildings.get((Object)type).get(level);
    }

    @Override
    public ResearchTemplate getResearch(int templateId) {
        return this.researches.get(templateId);
    }

    @Override
    public Collection<ResearchTemplate> getResearches() {
        return this.researches.values();
    }

    @Override
    public Optional<Integer> getBuildingEffectValue(BuildingEffectName name, int level) {
        return Optional.ofNullable(this.buildingEffects.getOrDefault((Object)name, Collections.emptyMap()).get(level));
    }
}

