/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.common;

import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;

public class RandomUtils {
    private static Random random = new Random();

    public static int getRandomInt(int min, int max) {
        if (min >= max) {
            return min;
        }
        return random.nextInt(max - min + 1) + min;
    }

    public static <T> T getRandomListItem(List<T> list) {
        return list.get(random.nextInt(list.size()));
    }

    public static <T> T getRandomArrayItem(T[] array) {
        return array[random.nextInt(array.length)];
    }

    public static <T> Map.Entry<Double, T> getRandomWeightedNavigableMapEntry(NavigableMap<Double, T> map) {
        double max = (Double)map.lastKey();
        return map.ceilingEntry(max * random.nextDouble());
    }

    public static <T> T getRandomWeightedNavigableMapValue(NavigableMap<Double, T> map) {
        return RandomUtils.getRandomWeightedNavigableMapEntry(map).getValue();
    }
}

