/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.loaders;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import ru.quadcom.commons.exceptions.ServiceException;

public abstract class Loader<R> {
    private String resourceUrl;
    private String prefix;
    private static Gson gson = new GsonBuilder().create();

    public Loader(String resourceUrl, String prefix) {
        this.resourceUrl = resourceUrl;
        this.prefix = prefix;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<R> load0(String fileName) {
        File file = new File(this.resourceUrl + "/" + this.prefix);
        if (!file.exists()) {
            throw new ServiceException(this.resourceUrl + " not found", null);
        }
        File[] files = file.listFiles(name -> name.getName().equals(fileName));
        if (files == null) throw new ServiceException(fileName + " not found", null);
        if (files.length == 0) {
            throw new ServiceException(fileName + " not found", null);
        }
        try (FileReader fr = new FileReader(files[0]);){
            List list = (List)gson.fromJson((Reader)fr, this.getType());
            return list;
        }
        catch (FileNotFoundException e) {
            throw new ServiceException(fileName + " not found", (Throwable)e, null);
        }
        catch (IOException e) {
            throw new ServiceException(fileName + " load error", (Throwable)e, null);
        }
    }

    protected abstract Type getType();

    public abstract Object load(String var1);
}

