/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.loaders.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.quadcom.datapack.loaders.Loader;
import ru.quadcom.datapack.templates.common.ItemFraction;

public class ItemFractionLoader
extends Loader<ItemFraction> {
    public ItemFractionLoader(String resourceUrl, String prefix) {
        super(resourceUrl, prefix);
    }

    @Override
    protected Type getType() {
        return new TypeToken<List<ItemFraction>>(){}.getType();
    }

    @Override
    public Map<Integer, Set<Integer>> load(String fileName) {
        List itemFractions = this.load0(fileName);
        HashMap result = Maps.newHashMap();
        for (ItemFraction itemFraction : itemFractions) {
            Set set = result.computeIfAbsent(itemFraction.getItemTemplateId(), k -> Sets.newHashSet());
            set.add(itemFraction.getFractionId());
        }
        return result;
    }
}

