/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import java.util.List;
import java.util.Map;
import ru.quadcom.datapack.domains.ExperienceConfig;
import ru.quadcom.datapack.domains.SpikePointsConfig;
import ru.quadcom.datapack.domains.battleeffects.BattleEffect;
import ru.quadcom.datapack.domains.battleeffects.BattleEffectType;
import ru.quadcom.datapack.loaders.impl.BaseConstantsLoader;
import ru.quadcom.datapack.loaders.impl.BattleEffectsLoader;
import ru.quadcom.datapack.loaders.impl.ExpConfigLoader;
import ru.quadcom.datapack.loaders.impl.SkillConfigLoader;
import ru.quadcom.datapack.loaders.impl.SpikePointsConfigLoader;
import ru.quadcom.datapack.services.ICommonPack;
import ru.quadcom.datapack.templates.common.BaseConstantsTemplate;

public class CommonPack
implements ICommonPack {
    private Map<String, BaseConstantsTemplate> baseConstants;
    private ExperienceConfig experienceConfig;
    private SpikePointsConfig spikePointsConfig;
    private Map<BattleEffectType, BattleEffect> battleEffectsConfig;
    private List<Integer> skillsConfig;
    private String prefix = "";

    CommonPack(String resourceUrl) {
        this.baseConstants = new BaseConstantsLoader(resourceUrl, this.prefix).load("base_constants.json");
        this.experienceConfig = (ExperienceConfig)new ExpConfigLoader(resourceUrl, this.prefix).load("experience_config.json").get(0);
        this.spikePointsConfig = (SpikePointsConfig)new SpikePointsConfigLoader(resourceUrl, this.prefix).load("spike_points_config.json").get(0);
        this.battleEffectsConfig = new BattleEffectsLoader(resourceUrl, this.prefix).load("battle_effects.json");
        this.skillsConfig = (List)new SkillConfigLoader(resourceUrl, this.prefix).load("skills_config.json").get(0);
    }

    @Override
    public BaseConstantsTemplate getBaseConstant(String descriptor) {
        return this.baseConstants.get(descriptor);
    }

    @Override
    public ExperienceConfig getExpConfig() {
        return this.experienceConfig;
    }

    @Override
    public SpikePointsConfig getSpikePointsConfig() {
        return this.spikePointsConfig;
    }

    @Override
    public Map<BattleEffectType, BattleEffect> getBattleEffects() {
        return this.battleEffectsConfig;
    }

    @Override
    public List<Integer> getSkillsConfig() {
        return this.skillsConfig;
    }
}

