/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.datapack.services.impl;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import one.util.streamex.StreamEx;
import ru.quadcom.datapack.domains.operator.DefaultEquipment;
import ru.quadcom.datapack.loaders.impl.AvatarLoader;
import ru.quadcom.datapack.loaders.impl.CharacterGenerationsLoader;
import ru.quadcom.datapack.loaders.impl.ClassesLoader;
import ru.quadcom.datapack.loaders.impl.DefaultEquipmentLoader;
import ru.quadcom.datapack.loaders.impl.FractionsLoader;
import ru.quadcom.datapack.loaders.impl.GendersLoader;
import ru.quadcom.datapack.loaders.impl.RacesLoader;
import ru.quadcom.datapack.loaders.impl.RanksLoader;
import ru.quadcom.datapack.loaders.impl.RaritiesLoader;
import ru.quadcom.datapack.services.IOperatorPack;
import ru.quadcom.datapack.templates.operator.AvatarTemplate;
import ru.quadcom.datapack.templates.operator.CharacterGenerationTemplate;
import ru.quadcom.datapack.templates.operator.ClassTemplate;
import ru.quadcom.datapack.templates.operator.FractionTemplate;
import ru.quadcom.datapack.templates.operator.GenderTemplate;
import ru.quadcom.datapack.templates.operator.RaceTemplate;
import ru.quadcom.datapack.templates.operator.RankTemplate;
import ru.quadcom.datapack.templates.operator.RarityTemplate;

public class OperatorPack
implements IOperatorPack {
    private static Random random = new Random();
    private Map<String, AvatarTemplate> avatarTemplates;
    private Map<Integer, ClassTemplate> classTemplates;
    private NavigableMap<Double, ClassTemplate> randomBaseClassTemplates;
    private Map<Integer, RankTemplate> rankTemplates;
    private NavigableMap<Long, RankTemplate> experienceRankTemplates;
    private Map<Integer, FractionTemplate> fractionTemplates;
    private Map<Integer, GenderTemplate> genderTemplates;
    private Map<Integer, RaceTemplate> raceTemplates;
    private Map<Integer, RarityTemplate> rarityTemplates;
    private NavigableMap<Double, RarityTemplate> randomRarityTemplates;
    private Map<Integer, CharacterGenerationTemplate> characterGenerationTemplates;
    private NavigableMap<Double, CharacterGenerationTemplate> randomCharacterGenerationTemplates;
    private Map<Integer, DefaultEquipment> defaultEquipments;
    private String prefix = "";

    OperatorPack(String resourceUrl) {
        this.avatarTemplates = new AvatarLoader(resourceUrl, this.prefix).load("avatars.json");
        this.classTemplates = new ClassesLoader(resourceUrl, this.prefix).load("classes.json");
        this.randomBaseClassTemplates = Maps.newTreeMap();
        ((StreamEx)StreamEx.of(this.classTemplates.values()).filter(ClassTemplate::isBase)).forEach(template -> {
            double max = (this.randomBaseClassTemplates.isEmpty() ? 0.0 : (Double)this.randomBaseClassTemplates.lastKey()) + template.getChance();
            this.randomBaseClassTemplates.put(max, (ClassTemplate)template);
        });
        this.rankTemplates = new RanksLoader(resourceUrl, this.prefix).load("ranks.json");
        this.experienceRankTemplates = Maps.newTreeMap();
        StreamEx.of(this.rankTemplates.values()).forEach(template -> this.experienceRankTemplates.put(template.getExperience(), (RankTemplate)template));
        this.fractionTemplates = new FractionsLoader(resourceUrl, this.prefix).load("fractions.json");
        this.genderTemplates = new GendersLoader(resourceUrl, this.prefix).load("genders.json");
        this.raceTemplates = new RacesLoader(resourceUrl, this.prefix).load("races.json");
        this.rarityTemplates = new RaritiesLoader(resourceUrl, this.prefix).load("rarities.json");
        this.randomRarityTemplates = Maps.newTreeMap();
        StreamEx.of(this.rarityTemplates.values()).forEach(template -> {
            double max = (this.randomRarityTemplates.isEmpty() ? 0.0 : (Double)this.randomRarityTemplates.lastKey()) + template.getChance();
            this.randomRarityTemplates.put(max, (RarityTemplate)template);
        });
        this.characterGenerationTemplates = new CharacterGenerationsLoader(resourceUrl, this.prefix).load("character_generations.json");
        this.randomCharacterGenerationTemplates = Maps.newTreeMap();
        StreamEx.of(this.characterGenerationTemplates.values()).forEach(template -> {
            double max = (this.randomCharacterGenerationTemplates.isEmpty() ? 0.0 : (Double)this.randomCharacterGenerationTemplates.lastKey()) + template.getChance();
            this.randomCharacterGenerationTemplates.put(max, (CharacterGenerationTemplate)template);
        });
        this.defaultEquipments = new DefaultEquipmentLoader(resourceUrl, this.prefix).load("default_equipments.json");
    }

    private <T> T getNextRandom(List<T> list) {
        return list.get(random.nextInt(list.size()));
    }

    @Override
    public DefaultEquipment getDefaultEquipment(ClassTemplate classTemplate) {
        return this.defaultEquipments.get(classTemplate.getId());
    }

    @Override
    public List<AvatarTemplate> getAvatars() {
        return StreamEx.of(this.avatarTemplates.values()).toList();
    }

    @Override
    public AvatarTemplate getAvatar(String name) {
        return this.avatarTemplates.get(name);
    }

    @Override
    public AvatarTemplate getNextAvatar(RaceTemplate race, GenderTemplate gender) {
        return (AvatarTemplate)((StreamEx)StreamEx.of(this.getAvatars()).filter(avatar -> avatar.getSex() == gender.getId() && avatar.getRace() == race.getId())).findFirst().get();
    }

    @Override
    public List<ClassTemplate> getClasses() {
        return StreamEx.of(this.classTemplates.values()).toList();
    }

    @Override
    public ClassTemplate getClass(int id) {
        return this.classTemplates.get(id);
    }

    @Override
    public ClassTemplate getNextBaseClass() {
        double max = (Double)this.randomBaseClassTemplates.lastKey();
        return this.randomBaseClassTemplates.ceilingEntry(max * random.nextDouble()).getValue();
    }

    @Override
    public List<FractionTemplate> getFractions() {
        return StreamEx.of(this.fractionTemplates.values()).toList();
    }

    @Override
    public FractionTemplate getFraction(int id) {
        return this.fractionTemplates.get(id);
    }

    @Override
    public FractionTemplate getNextFraction() {
        return this.getNextRandom(this.getFractions());
    }

    @Override
    public List<GenderTemplate> getGenders() {
        return StreamEx.of(this.genderTemplates.values()).toList();
    }

    @Override
    public GenderTemplate getGender(int id) {
        return this.genderTemplates.get(id);
    }

    @Override
    public GenderTemplate getNextGender() {
        return this.getNextRandom(this.getGenders());
    }

    @Override
    public List<RaceTemplate> getRaces() {
        return StreamEx.of(this.raceTemplates.values()).toList();
    }

    @Override
    public RaceTemplate getRace(int id) {
        return this.raceTemplates.get(id);
    }

    @Override
    public RaceTemplate getNextRace() {
        return this.getNextRandom(this.getRaces());
    }

    @Override
    public List<RankTemplate> getRanks() {
        return StreamEx.of(this.rankTemplates.values()).toList();
    }

    @Override
    public RankTemplate getRank(int id) {
        return this.rankTemplates.get(id);
    }

    @Override
    public RankTemplate getNextRank() {
        return (RankTemplate)StreamEx.of(this.getRanks()).min(Comparator.comparingLong(RankTemplate::getExperience)).get();
    }

    @Override
    public RankTemplate getRankForExperience(long experience) {
        return this.experienceRankTemplates.floorEntry(experience).getValue();
    }

    @Override
    public List<RarityTemplate> getRarities() {
        return StreamEx.of(this.rarityTemplates.values()).toList();
    }

    @Override
    public RarityTemplate getRarity(int id) {
        return this.rarityTemplates.get(id);
    }

    @Override
    public RarityTemplate getNextRarity() {
        double max = (Double)this.randomRarityTemplates.lastKey();
        return this.randomRarityTemplates.ceilingEntry(max * random.nextDouble()).getValue();
    }

    @Override
    public List<CharacterGenerationTemplate> getCharacterGenerationTemplates() {
        return StreamEx.of(this.characterGenerationTemplates.values()).toList();
    }

    @Override
    public CharacterGenerationTemplate getCharacterGeneration(int id) {
        return this.characterGenerationTemplates.get(id);
    }

    @Override
    public CharacterGenerationTemplate getNextCharacterGeneration() {
        double max = (Double)this.randomRarityTemplates.lastKey();
        return this.randomCharacterGenerationTemplates.ceilingEntry(max * random.nextDouble()).getValue();
    }
}

