/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.templates.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.quadcom.domains.item.ItemAction;
import ru.quadcom.domains.item.ItemActionType;
import ru.quadcom.domains.item.ItemClass;
import ru.quadcom.domains.item.ItemDefaultProperty;
import ru.quadcom.domains.item.ItemQuality;
import ru.quadcom.domains.item.ItemSubClass;
import ru.quadcom.domains.item.ItemTemplateProperty;

public class ItemTemplate {
    private int id;
    private String guid;
    private String descriptor;
    private ItemQuality quality;
    private int durability;
    private boolean isStackable;
    private ItemClass itemClass;
    private ItemSubClass itemSubClass;
    private int minStrength;
    private int minIntelligence;
    private List<ItemTemplateProperty> templateProperties;
    private List<ItemDefaultProperty> defaultItemProperties;
    private List<ItemAction> actions;
    private transient Map<ItemActionType, ItemAction> actionsMap;

    public ItemTemplate(int id, String guid, String descriptor, ItemQuality quality, int durability, boolean isStackable, ItemClass itemClass, ItemSubClass itemSubClass, int minStrength, int minIntelligence, List<ItemTemplateProperty> templateProperties, List<ItemDefaultProperty> defaultItemProperties, List<ItemAction> actions) {
        this.id = id;
        this.guid = guid;
        this.descriptor = descriptor;
        this.quality = quality;
        this.durability = durability;
        this.isStackable = isStackable;
        this.itemClass = itemClass;
        this.itemSubClass = itemSubClass;
        this.minStrength = minStrength;
        this.minIntelligence = minIntelligence;
        this.templateProperties = templateProperties;
        this.defaultItemProperties = defaultItemProperties;
        this.actions = actions;
    }

    public int getId() {
        return this.id;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public ItemQuality getQuality() {
        return this.quality;
    }

    public int getDurability() {
        return this.durability;
    }

    public boolean isStackable() {
        return this.isStackable;
    }

    public ItemClass getItemClass() {
        return this.itemClass;
    }

    public ItemSubClass getItemSubClass() {
        return this.itemSubClass;
    }

    public int getMinStrength() {
        return this.minStrength;
    }

    public int getMinIntelligence() {
        return this.minIntelligence;
    }

    public List<ItemTemplateProperty> getTemplateProperties() {
        return this.templateProperties;
    }

    public List<ItemDefaultProperty> getDefaultItemProperties() {
        return this.defaultItemProperties;
    }

    public List<ItemAction> getActions() {
        return this.actions;
    }

    public Map<ItemActionType, ItemAction> getActionsMap() {
        return this.actionsMap;
    }

    public void preProcess() {
        this.actionsMap = new HashMap<ItemActionType, ItemAction>();
        for (ItemAction action : this.actions) {
            action.preProcess();
            this.actionsMap.put(action.getId(), action);
        }
    }
}

