/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.services.impl;

import java.util.List;
import java.util.Map;
import ru.quadcom.domains.item.ItemActionType;
import ru.quadcom.domains.item.ItemStack;
import ru.quadcom.loaders.impl.ItemPropertiesLoader;
import ru.quadcom.loaders.impl.ItemsLoader;
import ru.quadcom.services.IItemPack;
import ru.quadcom.templates.item.ClassDefaultItemsTemplate;
import ru.quadcom.templates.item.ItemActionTemplate;
import ru.quadcom.templates.item.ItemPropertyTemplate;
import ru.quadcom.templates.item.ItemTemplate;

public class ItemPack
implements IItemPack {
    private String prefix = "";
    private Map<Integer, ItemTemplate> itemTemplates;
    private Map<ItemActionType, ItemActionTemplate> itemActionTemplates;
    private Map<Integer, ItemPropertyTemplate> itemPropertyTemplates;
    private Map<String, ClassDefaultItemsTemplate> classDefaultItemsTemplates;
    private List<ItemStack> profileDefaultInventory;

    ItemPack(String resourceUrl) {
        this.itemTemplates = new ItemsLoader(resourceUrl, this.prefix).load("items.json");
        this.itemPropertyTemplates = new ItemPropertiesLoader(resourceUrl, this.prefix).load("item_properties.json");
        this.preProcessItemTemplates();
    }

    @Override
    public ItemTemplate getItemTemplate(int itemTemplateId) {
        return this.itemTemplates.get(itemTemplateId);
    }

    @Override
    public ItemActionTemplate getItemActionTemplate(int itemActionId) {
        return this.itemActionTemplates.get(itemActionId);
    }

    @Override
    public ItemPropertyTemplate getItemPropertyTemplate(int itemPropertyTemplateId) {
        return this.itemPropertyTemplates.get(itemPropertyTemplateId);
    }

    @Override
    public ClassDefaultItemsTemplate getClassDefaultItemsTemplate(int classId, int rarityId) {
        return this.classDefaultItemsTemplates.get(classId + ":" + rarityId);
    }

    @Override
    public List<ItemStack> getProfileDefaultInventory() {
        return this.profileDefaultInventory;
    }

    private void preProcessItemTemplates() {
        for (ItemTemplate itemTemplate : this.itemTemplates.values()) {
            itemTemplate.preProcess();
        }
    }
}

