/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.domains.identity;

import java.util.UUID;

public class Session {
    private String sessionId;
    private long accountId;
    private long profileId;

    private Session(long accountId) {
        this(accountId, 0L);
    }

    private Session(long accountId, long profileId) {
        this(UUID.randomUUID().toString(), accountId, profileId);
    }

    private Session(String sessionId, long accountId, long profileId) {
        this.sessionId = sessionId;
        this.accountId = accountId;
        this.profileId = profileId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public long getAccountId() {
        return this.accountId;
    }

    public long getProfileId() {
        return this.profileId;
    }

    public static Session create(long accountId) {
        return new Session(accountId);
    }

    public static Session create(long accountId, long profileId) {
        return new Session(accountId, profileId);
    }

    public static Session update(Session session, long profileId) {
        return new Session(session.getSessionId(), session.getAccountId(), profileId);
    }
}

