/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.domains.operator;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import one.util.streamex.StreamEx;
import ru.quadcom.domains.operator.Spike;
import ru.quadcom.templates.operator.AppearanceTemplate;
import ru.quadcom.templates.operator.ClassTemplate;
import ru.quadcom.templates.operator.GenderTemplate;
import ru.quadcom.templates.operator.RaceTemplate;
import ru.quadcom.templates.operator.RankTemplate;
import ru.quadcom.templates.operator.RarityTemplate;
import ru.quadcom.templates.operator.StartSpikeSetTemplate;

public class Operator {
    private long id;
    private long profileId;
    private String name;
    private GenderTemplate gender;
    private RaceTemplate race;
    private RarityTemplate rarity;
    private RankTemplate rank;
    private StartSpikeSetTemplate startSpikeSetTemplate;
    private long experience;
    private int strength;
    private int perception;
    private int intelligence;
    private int knack;
    private int endurance;
    private int strengthActionCounter;
    private int perceptionActionCounter;
    private int intelligenceActionCounter;
    private int knackActionCounter;
    private int enduranceActionCounter;
    private Map<Integer, ClassTemplate> classes = Maps.newHashMap();
    private Map<Integer, AppearanceTemplate> appearances = Maps.newHashMap();
    private int place;
    private Spike spike = new OperatorSpike();

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getProfileId() {
        return this.profileId;
    }

    public void setProfileId(long profileId) {
        this.profileId = profileId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GenderTemplate getGender() {
        return this.gender;
    }

    public void setGender(GenderTemplate gender) {
        this.gender = gender;
    }

    public RaceTemplate getRace() {
        return this.race;
    }

    public void setRace(RaceTemplate race) {
        this.race = race;
    }

    public RarityTemplate getRarity() {
        return this.rarity;
    }

    public void setRarity(RarityTemplate rarity) {
        this.rarity = rarity;
    }

    public RankTemplate getRank() {
        return this.rank;
    }

    public void setRank(RankTemplate rank) {
        this.rank = rank;
    }

    public StartSpikeSetTemplate getStartSpikeSetTemplate() {
        return this.startSpikeSetTemplate;
    }

    public void setStartSpikeSetTemplate(StartSpikeSetTemplate startSpikeSetTemplate) {
        this.startSpikeSetTemplate = startSpikeSetTemplate;
    }

    public long getExperience() {
        return this.experience;
    }

    public void setExperience(long experience) {
        this.experience = experience;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    public int getPerception() {
        return this.perception;
    }

    public void setPerception(int perception) {
        this.perception = perception;
    }

    public int getIntelligence() {
        return this.intelligence;
    }

    public void setIntelligence(int intelligence) {
        this.intelligence = intelligence;
    }

    public int getKnack() {
        return this.knack;
    }

    public void setKnack(int knack) {
        this.knack = knack;
    }

    public int getEndurance() {
        return this.endurance;
    }

    public void setEndurance(int endurance) {
        this.endurance = endurance;
    }

    public int getStrengthActionCounter() {
        return this.strengthActionCounter;
    }

    public void setStrengthActionCounter(int strengthActionCounter) {
        this.strengthActionCounter = strengthActionCounter;
    }

    public int getPerceptionActionCounter() {
        return this.perceptionActionCounter;
    }

    public void setPerceptionActionCounter(int perceptionActionCounter) {
        this.perceptionActionCounter = perceptionActionCounter;
    }

    public int getIntelligenceActionCounter() {
        return this.intelligenceActionCounter;
    }

    public void setIntelligenceActionCounter(int intelligenceActionCounter) {
        this.intelligenceActionCounter = intelligenceActionCounter;
    }

    public int getKnackActionCounter() {
        return this.knackActionCounter;
    }

    public void setKnackActionCounter(int knackActionCounter) {
        this.knackActionCounter = knackActionCounter;
    }

    public int getEnduranceActionCounter() {
        return this.enduranceActionCounter;
    }

    public void setEnduranceActionCounter(int enduranceActionCounter) {
        this.enduranceActionCounter = enduranceActionCounter;
    }

    public Collection<ClassTemplate> getClasses() {
        return Collections.unmodifiableCollection(this.classes.values());
    }

    public boolean existsClass(ClassTemplate template) {
        return this.classes.containsKey(template.getId());
    }

    public void addClass(ClassTemplate classTemplate) {
        this.classes.put(classTemplate.getId(), classTemplate);
    }

    public Collection<AppearanceTemplate> getAppearances() {
        return Collections.unmodifiableCollection(this.appearances.values());
    }

    public boolean existsAppearance(AppearanceTemplate template) {
        return this.appearances.containsKey(template.getId());
    }

    public void addAppearance(AppearanceTemplate template) {
        this.appearances.put(template.getId(), template);
    }

    public int getPlace() {
        return this.place;
    }

    public void setPlace(int place) {
        this.place = place;
    }

    public Spike getSpike() {
        return this.spike;
    }

    public ClassTemplate getBaseClass() {
        return (ClassTemplate)((StreamEx)StreamEx.of(this.classes.values()).filter(ClassTemplate::isBase)).findFirst().get();
    }

    private class OperatorSpike
    implements Spike {
        private OperatorSpike() {
        }

        @Override
        public int getStrength() {
            return Operator.this.strength + Operator.this.race.getStrength() + Operator.this.startSpikeSetTemplate.getStrength();
        }

        @Override
        public int getPerception() {
            return Operator.this.perception + Operator.this.race.getPerception() + Operator.this.startSpikeSetTemplate.getPerception();
        }

        @Override
        public int getIntelligence() {
            return Operator.this.intelligence + Operator.this.race.getIntelligence() + Operator.this.startSpikeSetTemplate.getIntelligence();
        }

        @Override
        public int getKnack() {
            return Operator.this.knack + Operator.this.race.getKnack() + Operator.this.startSpikeSetTemplate.getKnack();
        }

        @Override
        public int getEndurance() {
            return Operator.this.endurance + Operator.this.race.getEndurance() + Operator.this.startSpikeSetTemplate.getEndurance();
        }
    }
}

