/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.services.impl;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import one.util.streamex.StreamEx;
import ru.quadcom.loaders.impl.AppearancesLoader;
import ru.quadcom.loaders.impl.ClassesLoader;
import ru.quadcom.loaders.impl.FractionsLoader;
import ru.quadcom.loaders.impl.GendersLoader;
import ru.quadcom.loaders.impl.RacesLoader;
import ru.quadcom.loaders.impl.RanksLoader;
import ru.quadcom.loaders.impl.RaritiesLoader;
import ru.quadcom.services.ITemplateService;
import ru.quadcom.templates.AppearanceTemplate;
import ru.quadcom.templates.ClassTemplate;
import ru.quadcom.templates.FractionTemplate;
import ru.quadcom.templates.GenderTemplate;
import ru.quadcom.templates.RaceTemplate;
import ru.quadcom.templates.RankTemplate;
import ru.quadcom.templates.RarityTemplate;

public class TemplateService
implements ITemplateService {
    private static Random random = new Random();
    private Map<Integer, AppearanceTemplate> appearanceTemplates;
    private Map<Integer, ClassTemplate> classTemplates;
    private Map<Integer, RankTemplate> rankTemplates;
    private Map<Integer, FractionTemplate> fractionTemplates;
    private Map<Integer, GenderTemplate> genderTemplates;
    private Map<Integer, RaceTemplate> raceTemplates;
    private Map<Integer, RarityTemplate> rarityTemplates;
    private NavigableMap<Double, RarityTemplate> randomRarityTemplates;

    public TemplateService(String resourceUrl) {
        this.appearanceTemplates = new AppearancesLoader(resourceUrl).load("appearances.json");
        this.classTemplates = new ClassesLoader(resourceUrl).load("classes.json");
        this.rankTemplates = new RanksLoader(resourceUrl).load("ranks.json");
        this.fractionTemplates = new FractionsLoader(resourceUrl).load("fractions.json");
        this.genderTemplates = new GendersLoader(resourceUrl).load("genders.json");
        this.raceTemplates = new RacesLoader(resourceUrl).load("races.json");
        this.rarityTemplates = new RaritiesLoader(resourceUrl).load("rarities.json");
        this.randomRarityTemplates = Maps.newTreeMap();
        StreamEx.of(this.rarityTemplates.values()).forEach(template -> {
            double max = this.randomRarityTemplates.isEmpty() ? 0.0 : (Double)this.randomRarityTemplates.lastKey() + (double)template.getWeight();
            this.randomRarityTemplates.put(max, (RarityTemplate)template);
        });
    }

    private <T> T getNextRandom(List<T> list) {
        return list.get(random.nextInt(list.size()));
    }

    @Override
    public List<AppearanceTemplate> getAppearances() {
        return StreamEx.of(this.appearanceTemplates.values()).toList();
    }

    @Override
    public AppearanceTemplate getAppearance(int id) {
        return this.appearanceTemplates.get(id);
    }

    @Override
    public AppearanceTemplate getNextAppearance() {
        return this.getNextRandom(this.getAppearances());
    }

    @Override
    public List<ClassTemplate> getClasses() {
        return StreamEx.of(this.classTemplates.values()).toList();
    }

    @Override
    public ClassTemplate getClass(int id) {
        return this.classTemplates.get(id);
    }

    @Override
    public ClassTemplate getNextClass() {
        return this.getNextRandom(this.getClasses());
    }

    @Override
    public List<FractionTemplate> getFractions() {
        return StreamEx.of(this.fractionTemplates.values()).toList();
    }

    @Override
    public FractionTemplate getFraction(int id) {
        return this.fractionTemplates.get(id);
    }

    @Override
    public FractionTemplate getNextFraction() {
        return this.getNextRandom(this.getFractions());
    }

    @Override
    public List<GenderTemplate> getGenders() {
        return StreamEx.of(this.genderTemplates.values()).toList();
    }

    @Override
    public GenderTemplate getGender(int id) {
        return this.genderTemplates.get(id);
    }

    @Override
    public GenderTemplate getNextGender() {
        return this.getNextRandom(this.getGenders());
    }

    @Override
    public List<RaceTemplate> getRaces() {
        return StreamEx.of(this.raceTemplates.values()).toList();
    }

    @Override
    public RaceTemplate getRace(int id) {
        return this.raceTemplates.get(id);
    }

    @Override
    public RaceTemplate getNextRace() {
        return this.getNextRandom(this.getRaces());
    }

    @Override
    public List<RankTemplate> getRanks() {
        return StreamEx.of(this.rankTemplates.values()).toList();
    }

    @Override
    public RankTemplate getRank(int id) {
        return this.rankTemplates.get(id);
    }

    @Override
    public RankTemplate getNextRank() {
        return (RankTemplate)StreamEx.of(this.getRanks()).min(Comparator.comparingLong(RankTemplate::getExperience)).get();
    }

    @Override
    public List<RarityTemplate> getRarities() {
        return StreamEx.of(this.rarityTemplates.values()).toList();
    }

    @Override
    public RarityTemplate getRarity(int id) {
        return this.rarityTemplates.get(id);
    }

    @Override
    public RarityTemplate getNextRarity() {
        double max = (Double)this.randomRarityTemplates.lastKey();
        return this.randomRarityTemplates.ceilingEntry(max * random.nextDouble()).getValue();
    }
}

