/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Maps;
import io.lettuce.core.pubsub.RedisPubSubListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import ru.quadcom.commons.exceptions.MissingParameterException;
import ru.quadcom.datapack.domains.identity.Session;
import ru.quadcom.dbtool.IRedisChannelService;
import ru.quadcom.dbtool.ISessionInMemoryCache;
import ru.quadcom.dbtool.RedisChannel;
import ru.quadcom.dbtool.redislisteners.SessionListener;
import ru.quadcom.exceptions.ErrorException;
import ru.quadcom.exceptions.FatalErrorException;
import ru.quadcom.prototool.gateway.ISessionProvider;

public abstract class SessionInMemoryCache
implements ISessionInMemoryCache {
    protected LoadingCache<String, Optional<Session>> cache;

    public SessionInMemoryCache(IRedisChannelService redisChannelService, final ISessionProvider sessionProvider) {
        this.cache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).removalListener((RemovalListener)new RemovalListener<String, Optional<Session>>(){

            public void onRemoval(RemovalNotification<String, Optional<Session>> removalNotification) {
                if (removalNotification.getCause() == RemovalCause.EXPIRED) {
                    // empty if block
                }
            }
        }).build((CacheLoader)new CacheLoader<String, Optional<Session>>(){

            public Optional<Session> load(String sessionId) throws ExecutionException, InterruptedException {
                return Optional.ofNullable(sessionProvider.getSession(sessionId).toCompletableFuture().get());
            }
        });
        redisChannelService.subscribe(RedisChannel.SESSION_ALL, (RedisPubSubListener<String, String>)new SessionListener(this, RedisChannel.SESSION_ALL));
    }

    @Override
    public Session authorizeWithProfile(String sessionId) {
        if (sessionId == null) {
            throw new MissingParameterException("Missing access token", null);
        }
        Session session = this.getSession(sessionId);
        if (session.getAccountId() > 0L) {
            if (session.getProfileId() > 0L) {
                return session;
            }
            this.invalidate(session.getSessionId());
            session = this.getSession(sessionId);
            if (session.getAccountId() > 0L && session.getProfileId() > 0L) {
                return session;
            }
        }
        throw new MissingParameterException("Session corrupted", null);
    }

    @Override
    public Session getSession(String sessionId) {
        try {
            return (Session)((Optional)this.cache.get((Object)sessionId)).orElseThrow(() -> new FatalErrorException("Session not found"));
        }
        catch (ExecutionException e) {
            throw new ErrorException("Session not found. Find error.", (Throwable)e);
        }
    }

    @Override
    public void invalidate(String sessionId) {
        this.cache.invalidate((Object)sessionId);
    }

    @Override
    public void put(Session session) {
        this.cache.put((Object)session.getSessionId(), Optional.of(session));
    }

    @Override
    public Long getCountSessions() {
        long size = this.cache.size();
        if (size < 10L) {
            HashMap c = Maps.newHashMap((Map)this.cache.asMap());
            size = c.size();
        }
        return size;
    }

    @Override
    public Map<Long, Integer> isOnline(List<Long> ids) {
        Map<Long, Integer> out = this.cache.asMap().entrySet().stream().collect(Collectors.toMap(e -> ((Session)((Optional)e.getValue()).get()).getAccountId(), e -> ids.contains(((Session)((Optional)e.getValue()).get()).getAccountId()) ? 1 : 0));
        return out;
    }

    @Override
    public Map<String, Session> getOnlineSessions() {
        HashMap<String, Session> out = new HashMap<String, Session>();
        this.cache.asMap().forEach((k, v) -> out.put((String)k, v.orElse(Session.create((long)(-1 * ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE)), (int)-1))));
        return out;
    }
}

