/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool.repository;

import com.google.common.collect.Lists;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import one.util.streamex.StreamEx;
import play.db.jpa.JPAApi;
import ru.quadcom.dbtool.AbstractRepository;
import ru.quadcom.dbtool.repository.IColumnEnumerator;
import ru.quadcom.dbtool.repository.IPersistentEntity;
import ru.quadcom.dbtool.repository.IRepository;
import scala.concurrent.ExecutionContextExecutor;

public abstract class AbstractRepositoryImpl<E, M extends IPersistentEntity>
extends AbstractRepository
implements IRepository<E, M> {
    public AbstractRepositoryImpl(ExecutionContextExecutor executionContextExecutor, JPAApi jpaApi, Config config) {
        super(executionContextExecutor, jpaApi, config);
    }

    protected abstract E modelToDomain(M var1);

    protected abstract M domainToModel(E var1);

    protected abstract Class<M> getType();

    @Override
    public CompletionStage<E> create(E entity) {
        Object newModel = this.domainToModel(entity);
        newModel.setId(0L);
        newModel.setRemove(false);
        return ((CompletableFuture)((CompletableFuture)this.supplyAsync(em -> em.createQuery("select m from " + this.getType().getSimpleName() + " m where m.remove=true", this.getType()).setMaxResults(1).getResultList()).thenCompose(removed -> {
            if (removed.size() > 0) {
                IPersistentEntity oldModel = (IPersistentEntity)removed.get(0);
                return this.supplyAsync((EntityManager em) -> {
                    int changed = em.createQuery("update " + this.getType().getSimpleName() + " m set m.remove=null where m.id=:id and  m.remove=true").setParameter("id", (Object)oldModel.getId()).executeUpdate();
                    if (changed > 0) {
                        em.detach((Object)oldModel);
                        newModel.setId(oldModel.getId());
                        return (IPersistentEntity)em.merge(newModel);
                    }
                    return null;
                }, this.findShard(oldModel.getId()));
            }
            return CompletableFuture.completedFuture(null);
        })).thenCompose(model -> {
            if (model != null) {
                return CompletableFuture.completedFuture(model);
            }
            return this.supplyAsync((EntityManager em) -> {
                em.persist(newModel);
                return newModel;
            }, AbstractRepository.DBQualifier.LAST);
        })).thenApply(this::modelToDomain);
    }

    @Override
    public CompletionStage<E> get(long id) {
        return this.supplyAsync((EntityManager em) -> {
            IPersistentEntity model = (IPersistentEntity)em.find(this.getType(), (Object)id);
            return this.modelToDomain(model);
        }, this.findShard(id));
    }

    @Override
    public CompletionStage<List<E>> getByValue(Object ownerId, IColumnEnumerator columnEnumerator) {
        return this.supplyAsync(em -> {
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaQuery q = cb.createQuery(this.getType());
            Root c = q.from(this.getType());
            Predicate p1 = cb.equal((Expression)c.get(columnEnumerator.getAttributeName()), ownerId);
            Predicate p2 = cb.equal((Expression)c.get("remove"), (Object)false);
            q.select((Selection)c).where((Expression)cb.and((Expression)p1, (Expression)p2));
            List models = em.createQuery(q).getResultList();
            return StreamEx.of((Collection)models).map(this::modelToDomain).toList();
        });
    }

    @Override
    public CompletionStage<List<E>> get(long ... ids) {
        CompletionStage<List<E>> result = CompletableFuture.completedFuture(Lists.newArrayList());
        for (long id : ids) {
            result = result.thenCombine(this.get(id), (list, e) -> {
                list.add(e);
                return list;
            });
        }
        return result;
    }

    @Override
    public CompletionStage<List<E>> get(Set<Long> ids) {
        CompletionStage<List<E>> result = CompletableFuture.completedFuture(Lists.newArrayList());
        for (long id : ids) {
            result = result.thenCombine(this.get(id), (list, e) -> {
                list.add(e);
                return list;
            });
        }
        return result;
    }

    @Override
    public CompletionStage<Boolean> update(E entity, IColumnEnumerator<M> ... fields) {
        return this.supplyAsync((EntityManager em) -> {
            M model = this.domainToModel(entity);
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaUpdate cu = cb.createCriteriaUpdate(this.getType());
            Root root = cu.from(this.getType());
            for (IColumnEnumerator field : fields) {
                cu.set(field.getAttributeName(), field.get(model));
            }
            cu.where((Expression)cb.equal((Expression)root.get("id"), (Object)model.getId()));
            int changed = em.createQuery(cu).executeUpdate();
            return changed > 0;
        }, AbstractRepository.DBQualifier.LAST);
    }

    @Override
    public CompletionStage<E> merge(E entity) {
        M model = this.domainToModel(entity);
        model.setRemove(false);
        return this.supplyAsync((EntityManager em) -> {
            IPersistentEntity merged = (IPersistentEntity)em.merge((Object)model);
            return this.modelToDomain(merged);
        }, this.findShard(model.getId()));
    }

    @Override
    public CompletionStage<Boolean> remove(long id) {
        return this.supplyAsync((EntityManager em) -> {
            CriteriaBuilder cb = em.getCriteriaBuilder();
            CriteriaUpdate cu = cb.createCriteriaUpdate(this.getType());
            Root root = cu.from(this.getType());
            cu.set("remove", (Object)true);
            cu.where((Expression)cb.equal((Expression)root.get("id"), (Object)id));
            int changed = em.createQuery(cu).executeUpdate();
            return changed > 0;
        }, this.findShard(id));
    }

    @Override
    public CompletionStage<Boolean> remove(long ... ids) {
        CompletionStage<Boolean> result = CompletableFuture.completedFuture(true);
        for (long id : ids) {
            result = result.thenCombine(this.remove(id), (res, rem) -> res != false && rem != false);
        }
        return result;
    }

    @Override
    public CompletionStage<Boolean> remove(Set<Long> ids) {
        CompletionStage<Boolean> result = CompletableFuture.completedFuture(true);
        for (long id : ids) {
            result = result.thenCombine(this.remove(id), (res, rem) -> res != false && rem != false);
        }
        return result;
    }

    @Override
    public CompletionStage<E> copy(long id) {
        return this.get(id).thenCompose(this::create);
    }
}

