/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.Environment;
import play.api.OptionalSourceMapper;
import play.api.PlayException;
import play.api.routing.Router;
import play.http.DefaultHttpErrorHandler;
import play.http.HttpEntity;
import play.mvc.Http;
import play.mvc.Result;
import ru.quadcom.dbtool.ProtoErrorHandler;
import ru.quadcom.exceptions.ErrorException;
import ru.quadcom.exceptions.FatalErrorException;
import ru.quadcom.exceptions.WarningException;
import ru.quadcom.play.util.controllers.BaseController;

@Singleton
public class HttpErrorHandler
extends DefaultHttpErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(ProtoErrorHandler.class);
    private static final Gson gson = new GsonBuilder().disableHtmlEscaping().create();

    @Inject
    public HttpErrorHandler(Config config, Environment environment, OptionalSourceMapper sourceMapper, Provider<Router> routes) {
        super(config, environment, sourceMapper, routes);
    }

    public CompletionStage<Result> onServerError(Http.RequestHeader request, Throwable exception) {
        return CompletableFuture.supplyAsync(() -> HttpErrorHandler.handle(exception));
    }

    public static Result handle(Throwable cause) {
        while ((cause instanceof PlayException || cause instanceof CompletionException) && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof WarningException) {
            WarningException warningException = (WarningException)cause;
            return HttpErrorHandler.resultWithHeaders(200, new WarningMessage(warningException.getMessage(), warningException.getCode()));
        }
        if (cause instanceof ErrorException) {
            ErrorException errorException = (ErrorException)cause;
            logger.error("error [" + errorException.getId() + "]", cause);
            return HttpErrorHandler.resultWithHeaders(200, new ErrorMessage(errorException.getMessage(), errorException.getId()));
        }
        if (cause instanceof FatalErrorException) {
            FatalErrorException fatalErrorException = (FatalErrorException)cause;
            logger.warn("fatal error [" + fatalErrorException.getMessage() + "]");
            return HttpErrorHandler.resultWithHeaders(500, new WarningMessage(fatalErrorException.getMessage(), 0));
        }
        String id = UUID.randomUUID().toString();
        logger.error("internal error [" + id + "]", cause);
        return HttpErrorHandler.resultWithHeaders(200, new ErrorMessage(cause.getClass().getSimpleName() + (cause.getMessage() == null ? "" : cause.getMessage()), id));
    }

    private static Result resultWithHeaders(int status, Message message) {
        String desc = gson.toJson((Object)message);
        return BaseController.withHeaders((Result)new Result(status, HttpEntity.fromString((String)desc, (String)"utf-8")), (Map)BaseController.accessControlHeaders());
    }

    private static class Message {
        private final int statusCode;
        private final String errorMessage;

        public Message(int statusCode, String errorMessage) {
            this.statusCode = statusCode;
            this.errorMessage = errorMessage;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }
    }

    private static class WarningMessage
    extends Message {
        public WarningMessage(String errorMessage, int statusCode) {
            super(statusCode, errorMessage);
        }
    }

    private static class ErrorMessage
    extends Message {
        private final String id;

        public ErrorMessage(String errorMessage, String id) {
            super(6, errorMessage);
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

