/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.Environment;
import play.api.OptionalSourceMapper;
import play.api.PlayException;
import play.api.routing.Router;
import play.http.DefaultHttpErrorHandler;
import play.mvc.Http;
import play.mvc.Result;
import play.mvc.Results;
import ru.quadcom.exceptions.ErrorException;
import ru.quadcom.exceptions.WarningException;
import ru.quadcom.tactics.baseproto.Packet;
import ru.quadcom.tactics.baseproto.RS_Error;
import ru.quadcom.tactics.baseproto.RS_Warning;

@Singleton
public class ProtoErrorHandler
extends DefaultHttpErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(ProtoErrorHandler.class);

    @Inject
    public ProtoErrorHandler(Config config, Environment environment, OptionalSourceMapper sourceMapper, Provider<Router> routes) {
        super(config, environment, sourceMapper, routes);
    }

    public CompletionStage<Result> onServerError(Http.RequestHeader request, Throwable exception) {
        return CompletableFuture.supplyAsync(() -> ProtoErrorHandler.handle(exception));
    }

    private static Result handle(Throwable cause) {
        Packet packet;
        while ((cause instanceof PlayException || cause instanceof CompletionException) && cause.getCause() != null) {
            cause = cause.getCause();
        }
        if (cause instanceof WarningException) {
            WarningException warningException = (WarningException)cause;
            packet = Packet.newBuilder().setType(Packet.PacketType.RS_WARNING).setBody(RS_Warning.newBuilder().setMessage(warningException.getMessage()).setType(RS_Warning.WarningType.forNumber((int)warningException.getCode())).build().toByteString()).build();
        } else if (cause instanceof ErrorException) {
            logger.error("error", cause);
            ErrorException errorException = (ErrorException)cause;
            packet = Packet.newBuilder().setType(Packet.PacketType.RS_ERROR).setBody(RS_Error.newBuilder().setMessage(errorException.getMessage() == null ? "" : errorException.getMessage()).setId(errorException.getId()).build().toByteString()).build();
        } else {
            String id = UUID.randomUUID().toString();
            logger.error("internal error [" + id + "]", cause);
            packet = Packet.newBuilder().setType(Packet.PacketType.RS_ERROR).setBody(RS_Error.newBuilder().setMessage(cause.getClass().getSimpleName() + (cause.getMessage() == null ? "" : cause.getMessage())).setId(id).build().toByteString()).build();
        }
        return Results.ok((byte[])packet.toByteArray());
    }
}

