/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import ru.quadcom.commons.identity.ServiceToServiceToken;
import ru.quadcom.commons.identity.Token;
import ru.quadcom.datapack.domains.identity.Session;
import ru.quadcom.exceptions.FatalErrorException;

public abstract class AbstractBaseController
extends Controller {
    private static final Logger log = LoggerFactory.getLogger((String)"access");
    public static final String ACCESS_TOKEN_HEADER = "X-Access-Token";
    public static final String TOKEN = "token";
    public static final String SERVICE_TOKEN = "service_token";
    public static final String LOCALE = "locale";
    public static final String SESSION = "session";
    public static final String APPLICATION_NAME_HEADER = "X-Application-Name";
    public static final String REQUEST_SENT_TIME = "X-Request-Sent-Time";
    public static final String SESSION_ID_HEADER = "X-Session-Id";
    public static final String ALLOWED_HEADERS = "Accept, X-Access-Token, X-Application-Name, X-Request-Sent-Time, X-Session-Id";
    public static final String ALLOWED_METHODS = "GET, POST, OPTIONS";
    public static final String REQUEST_BODY = "requestBody";
    private static final Gson gson = new GsonBuilder().create();
    private static final Map<String, String> headersMap = new HashMap<String, String>();

    private static void storeRequestBody(Map<String, String[]> reqBody, Http.Request request) {
        Http.Context context = AbstractBaseController.ctx();
        context.args.put(REQUEST_BODY, reqBody);
        if (log.isDebugEnabled()) {
            log.debug(request.remoteAddress() + " " + request.method() + " " + request.path() + " " + AbstractBaseController.toJson(reqBody));
        }
    }

    private static Map<String, String[]> getRequestBody() {
        Map reqBody = null;
        if (AbstractBaseController.ctx().args.containsKey(REQUEST_BODY)) {
            reqBody = (Map)AbstractBaseController.ctx().args.get(REQUEST_BODY);
        }
        return reqBody;
    }

    private static Map<String, String[]> getCachedRequestParameters(Http.Request request) {
        Map<String, String[]> params = AbstractBaseController.getRequestBody();
        if (params == null || params.isEmpty()) {
            params = AbstractBaseController.getRequestParameters(request);
            AbstractBaseController.storeRequestBody(params, request);
        }
        return params;
    }

    public static Map<String, String[]> getRequestParameters(Http.Request request) {
        Map params;
        if ("GET".equals(request.method())) {
            params = request.queryString();
        } else {
            params = request.body().asFormUrlEncoded();
            if (params == null && request.body().asMultipartFormData() != null) {
                params = request.body().asMultipartFormData().asFormUrlEncoded();
            }
            if (params == null) {
                params = Maps.newHashMap();
            }
        }
        return params;
    }

    public static String getTokenString(Http.Request request) {
        String tokenString = AbstractBaseController.parseHeader(ACCESS_TOKEN_HEADER, request);
        if (tokenString == null && "GET".equalsIgnoreCase(request.method())) {
            String[] params = (String[])request.queryString().get("access_token");
            tokenString = params != null && params.length > 0 ? params[0] : null;
        }
        return tokenString;
    }

    public static String getApplicationName() {
        return AbstractBaseController.parseHeader(APPLICATION_NAME_HEADER, AbstractBaseController.request());
    }

    public static String getRequiredParameter(String paramName) {
        Map<String, String[]> map = AbstractBaseController.getCachedRequestParameters(AbstractBaseController.request());
        return AbstractBaseController.getRequiredParameter(paramName, map);
    }

    public static String getRequiredParameter(String paramName, Map<String, String[]> params) {
        String[] list = params.get(paramName);
        return AbstractBaseController.getRequiredParameter(paramName, list);
    }

    private static String getRequiredParameter(String paramName, String[] list) {
        if (list != null && list.length > 0) {
            if (list[0].isEmpty()) {
                throw new FatalErrorException("Empty parameter " + paramName);
            }
            return list[0];
        }
        throw new FatalErrorException("Missing parameter " + paramName);
    }

    public static Token getToken() {
        Token token = null;
        if (AbstractBaseController.ctx().args.containsKey(TOKEN)) {
            token = (Token)AbstractBaseController.ctx().args.get(TOKEN);
        }
        return token;
    }

    public static ServiceToServiceToken getServiceToken() {
        ServiceToServiceToken token = null;
        if (AbstractBaseController.ctx().args.containsKey(SERVICE_TOKEN)) {
            token = (ServiceToServiceToken)AbstractBaseController.ctx().args.get(SERVICE_TOKEN);
        }
        return token;
    }

    public static String getLocale() {
        String locale = null;
        if (AbstractBaseController.ctx().args.containsKey(LOCALE)) {
            locale = (String)AbstractBaseController.ctx().args.get(LOCALE);
        }
        return locale;
    }

    public CompletableFuture<Result> options() {
        return CompletableFuture.supplyAsync(() -> AbstractBaseController.withHeaders((Result)AbstractBaseController.ok(), AbstractBaseController.accessControlHeaders()));
    }

    public static Result withHeaders(Result result, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            result = result.withHeader(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Map<String, String> accessControlHeaders() {
        return headersMap;
    }

    public static Session getSession() {
        Session session = null;
        if (AbstractBaseController.ctx().args.containsKey(SESSION)) {
            session = (Session)AbstractBaseController.ctx().args.get(SESSION);
        }
        if (session == null) {
            throw new FatalErrorException("Session not found");
        }
        return session;
    }

    protected static <T> String toJson(T src) {
        return gson.toJson(src);
    }

    protected static <T> T fromJson(String json, Class<T> classOfT) {
        return (T)gson.fromJson(json, classOfT);
    }

    public static String checkString(String string, String defaultValue) {
        return string == null ? defaultValue : string;
    }

    public static String getRequiredOrEmptyParameter(String paramName) {
        String param = AbstractBaseController.getParameter(paramName);
        if (param == null) {
            throw new FatalErrorException("Missing parameter " + paramName);
        }
        return param;
    }

    public static String getParameter(String paramName) {
        String[] params = AbstractBaseController.getCachedRequestParameters(AbstractBaseController.request()).get(paramName);
        if (params != null && params.length > 0) {
            return params[0];
        }
        return null;
    }

    public static String parseHeader(String headerName, Http.Request request) {
        return request.getHeaders().get(headerName).orElse(null);
    }

    static {
        headersMap.put("Access-Control-Allow-Methods", ALLOWED_METHODS);
        headersMap.put("Access-Control-Allow-Origin", ALLOWED_HEADERS);
        headersMap.put("Access-Control-Allow-Credentials", "true");
    }
}

