/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import ru.quadcom.dbtool.IRedisChannel;

public enum RedisChannel implements IRedisChannel
{
    DATAPACK_UPDATE_REQUEST("datapack.update.request"),
    DATAPACK_UPDATE_RESPONSE("datapack.update.response"),
    SESSION_PROFILE("session.profile"),
    SESSION_ALL("session.all"),
    CHAT_LOGIN("chat.login"),
    CHAT_PLAYER_INFO("chat.player.info"),
    CHAT_CLAN_ADD("chat.clan.add"),
    CHAT_CLAN_REMOVE("chat.clan.remove"),
    CHAT_FRIEND_ADD("chat.friend.add"),
    CHAT_FRIEND_REMOVE("chat.friend.remove"),
    ACHIEVEMENT("achievement");

    private final String name;
    private static final Map<String, RedisChannel> map;

    private RedisChannel(String name) {
        this.name = name;
    }

    public static RedisChannel getByName(String name) {
        RedisChannel channel = map.get(name);
        if (channel == null) {
            throw new IllegalArgumentException("enum type has no constant with the name " + name);
        }
        return channel;
    }

    @Override
    public String getChannelName() {
        if (Strings.isNullOrEmpty((String)this.name)) {
            return this.name();
        }
        return this.name;
    }

    static {
        map = Arrays.stream(RedisChannel.values()).collect(Collectors.toMap(RedisChannel::getChannelName, Function.identity()));
    }
}

