/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool.redislisteners;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import ru.quadcom.dbtool.ISessionInMemoryCache;
import ru.quadcom.dbtool.redismessages.SessionMessage;
import ru.quadcom.domains.identity.Session;

public class SessionListener
extends RedisPubSubAdapter<String, String> {
    private ISessionInMemoryCache sessionInMemoryCache;
    private final Gson gson = new GsonBuilder().create();

    public SessionListener(ISessionInMemoryCache sessionInMemoryCache) {
        this.sessionInMemoryCache = sessionInMemoryCache;
    }

    public void message(String channel, String message) {
        SessionMessage sessionMessage = (SessionMessage)this.gson.fromJson(message, SessionMessage.class);
        Session oldSession = sessionMessage.getOldSession();
        Session newSession = sessionMessage.getNewSession();
        switch (sessionMessage.getType()) {
            case UPDATE: {
                this.sessionInMemoryCache.invalidate(oldSession.getSessionId());
                this.sessionInMemoryCache.put(newSession);
                break;
            }
            case CREATE: {
                this.sessionInMemoryCache.put(newSession);
                break;
            }
            case EXPIRE: {
                this.sessionInMemoryCache.invalidate(oldSession.getSessionId());
            }
        }
    }
}

