/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool.authactions;

import com.google.inject.Inject;
import java.util.concurrent.CompletionStage;
import play.mvc.Action;
import play.mvc.Http;
import play.mvc.Result;
import ru.quadcom.commons.exceptions.MissingParameterException;
import ru.quadcom.dbtool.ISessionInMemoryCache;
import ru.quadcom.dbtool.authactions.AuthorizeWithAccount;
import ru.quadcom.domains.identity.Session;
import ru.quadcom.play.util.RequestHelper;

public class AuthorizeWithAccountAction
extends Action<AuthorizeWithAccount> {
    private static final String ACCESS_TOKEN_HEADER = "X-Access-Token";
    @Inject
    private static ISessionInMemoryCache sessionInMemoryCache;

    public CompletionStage<Result> call(Http.Context ctx) {
        String tokenString = AuthorizeWithAccountAction.parseTokenString(ctx.request());
        ctx.args.put("session", AuthorizeWithAccountAction.authorize(tokenString));
        return this.delegate.call(ctx);
    }

    private static String parseTokenString(Http.Request request) {
        String tokenString = RequestHelper.parseHeader((String)ACCESS_TOKEN_HEADER, (Http.Request)request);
        if (tokenString == null && "GET".equalsIgnoreCase(request.method())) {
            String[] params = (String[])request.queryString().get("access_token");
            tokenString = params != null && params.length > 0 ? params[0] : null;
        }
        return tokenString;
    }

    private static Session authorize(String accessToken) {
        if (accessToken == null) {
            throw new MissingParameterException("Missing access token", null);
        }
        Session session = sessionInMemoryCache.getSession(accessToken);
        if (session.getAccountId() > 0L) {
            return session;
        }
        throw new MissingParameterException("Session corrupted", null);
    }
}

