/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import io.lettuce.core.support.ConnectionPoolSupport;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import play.inject.ApplicationLifecycle;
import ru.quadcom.commons.exceptions.ServiceException;
import ru.quadcom.dbtool.IRedisCacheService;
import ru.quadcom.dbtool.IRedisChannel;
import ru.quadcom.dbtool.IRedisChannelService;
import ru.quadcom.dbtool.redismessages.IRedisMessage;
import scala.concurrent.ExecutionContextExecutor;

public abstract class AbstractRedisService
implements IRedisCacheService,
IRedisChannelService {
    private final GenericObjectPool<StatefulRedisConnection<String, String>> pool;
    private final GenericObjectPool<StatefulRedisPubSubConnection<String, String>> subPool;
    private final ExecutionContextExecutor executionContext;

    public AbstractRedisService(String url, ApplicationLifecycle applicationLifecycle, ExecutionContextExecutor executionContext) {
        this.executionContext = executionContext;
        RedisURI uri = RedisURI.create((String)url);
        RedisClient client = RedisClient.create((RedisURI)uri);
        this.pool = ConnectionPoolSupport.createGenericObjectPool(() -> ((RedisClient)client).connect(), (GenericObjectPoolConfig)new GenericObjectPoolConfig());
        this.subPool = ConnectionPoolSupport.createGenericObjectPool(() -> ((RedisClient)client).connectPubSub(), (GenericObjectPoolConfig)new GenericObjectPoolConfig());
        applicationLifecycle.addStopHook(() -> CompletableFuture.runAsync(() -> {
            this.pool.close();
            this.subPool.close();
            client.shutdown();
        }));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> CompletableFuture<T> supply(Function<RedisCommands<String, String>, T> function) {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
            RedisCommands commands = connection.sync();
            CompletableFuture<Object> completableFuture = CompletableFuture.supplyAsync(() -> function.apply(commands), (Executor)this.executionContext);
            return completableFuture;
        }
        catch (Exception e) {
            throw new ServiceException("Error supply redis commands", (Throwable)e, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CompletableFuture<Void> run(Consumer<RedisCommands<String, String>> consumer) {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
            RedisCommands commands = connection.sync();
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> consumer.accept(commands), (Executor)this.executionContext);
            return completableFuture;
        }
        catch (Exception e) {
            throw new ServiceException("Error run redis commands", (Throwable)e, null);
        }
    }

    @Override
    @Deprecated
    public void subscribe(String channel, RedisPubSubListener<String, String> listener) {
        this.subscribe(() -> channel, listener);
    }

    @Override
    public void subscribe(IRedisChannel channel, RedisPubSubListener<String, String> listener) {
        try (StatefulRedisPubSubConnection connection = (StatefulRedisPubSubConnection)this.subPool.borrowObject();){
            connection.addListener(listener);
            RedisPubSubCommands commands = connection.sync();
            commands.subscribe((Object[])new String[]{channel.getChannelName()});
        }
        catch (Exception e) {
            throw new ServiceException("Error subscribe redis commands", (Throwable)e, null);
        }
    }

    @Override
    @Deprecated
    public void publish(String channel, String message) {
        this.publish(() -> channel, () -> message);
    }

    @Override
    public void publish(IRedisChannel channel, IRedisMessage message) {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
            RedisCommands commands = connection.sync();
            commands.publish((Object)channel.getChannelName(), (Object)message.toJson());
        }
        catch (Exception e) {
            throw new ServiceException("Error publish redis commands", (Throwable)e, null);
        }
    }

    @Override
    public <T> String getKey(Class<T> clazz, String id) {
        return clazz.getSimpleName() + ":" + id;
    }

    @Override
    @Deprecated
    public <T> String getKey(Class<T> clazz, long id) {
        return this.getKey(clazz, String.valueOf(id));
    }
}

