/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import io.lettuce.core.pubsub.RedisPubSubListener;
import java.util.concurrent.ExecutionException;
import ru.quadcom.commons.exceptions.ServiceException;
import ru.quadcom.dbtool.IRedisChannelService;
import ru.quadcom.dbtool.ISessionInMemoryCache;
import ru.quadcom.dbtool.RedisChannel;
import ru.quadcom.domains.identity.Session;
import ru.quadcom.prototool.gateway.IIdentityServiceGateway;

public abstract class SessionInMemoryCache
implements ISessionInMemoryCache {
    private final Gson gson = new GsonBuilder().create();
    private final LoadingCache<String, Session> cache;

    public SessionInMemoryCache(IRedisChannelService redisChannelService, final IIdentityServiceGateway identityServiceGateway) {
        this.cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Session>(){

            public Session load(String sessionId) throws ExecutionException, InterruptedException {
                return (Session)identityServiceGateway.getSession(sessionId).toCompletableFuture().get();
            }
        });
        redisChannelService.subscribe(RedisChannel.SESSION_PROFILE, (RedisPubSubListener<String, String>)new RedisPubSubAdapter<String, String>(){

            public void message(String channel, String message) {
                Session session = (Session)SessionInMemoryCache.this.gson.fromJson(message, Session.class);
                SessionInMemoryCache.this.cache.put((Object)session.getSessionId(), (Object)session);
            }
        });
    }

    @Override
    public Session getSession(String sessionId) {
        try {
            return (Session)this.cache.get((Object)sessionId);
        }
        catch (ExecutionException e) {
            throw new ServiceException("Session not found", (Throwable)e, null);
        }
    }
}

