/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import io.lettuce.core.support.ConnectionPoolSupport;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import play.api.Configuration;
import play.inject.ApplicationLifecycle;
import ru.quadcom.commons.exceptions.ServiceException;
import ru.quadcom.dbtool.DatabaseExecutionContext;
import scala.Option;

@Singleton
public class RC {
    private final GenericObjectPool<StatefulRedisConnection<String, String>> pool;
    private final DatabaseExecutionContext executionContext;

    @Inject
    public RC(ApplicationLifecycle applicationLifecycle, Configuration configuration, DatabaseExecutionContext executionContext) {
        this.executionContext = executionContext;
        RedisURI uri = RedisURI.create((String)((String)configuration.getString("redis.uri", Option.empty()).get()));
        RedisClient client = RedisClient.create((RedisURI)uri);
        this.pool = ConnectionPoolSupport.createGenericObjectPool(() -> ((RedisClient)client).connect(), (GenericObjectPoolConfig)new GenericObjectPoolConfig());
        applicationLifecycle.addStopHook(() -> CompletableFuture.runAsync(() -> {
            this.pool.close();
            client.shutdown();
        }));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> CompletableFuture<T> supply(Function<RedisCommands<String, String>, T> function) {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
            RedisCommands commands = connection.sync();
            CompletableFuture<Object> completableFuture = CompletableFuture.supplyAsync(() -> function.apply(commands), (Executor)((Object)this.executionContext));
            return completableFuture;
        }
        catch (Exception e) {
            throw new ServiceException("Error while process redis commands", (Throwable)e, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompletableFuture<Void> run(Consumer<RedisCommands<String, String>> consumer) {
        try (StatefulRedisConnection connection = (StatefulRedisConnection)this.pool.borrowObject();){
            RedisCommands commands = connection.sync();
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> consumer.accept(commands), (Executor)((Object)this.executionContext));
            return completableFuture;
        }
        catch (Exception e) {
            throw new ServiceException("Error while process redis commands", (Throwable)e, null);
        }
    }

    public <T> String getKey(Class<T> clazz, long id) {
        return clazz.getSimpleName() + ":" + id;
    }
}

