/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.dbtool;

import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.persistence.EntityManager;
import one.util.streamex.StreamEx;
import play.db.jpa.JPAApi;
import ru.quadcom.commons.exceptions.ServiceException;
import ru.quadcom.dbtool.DatabaseExecutionContext;

public abstract class Repository {
    private final DatabaseExecutionContext databaseExecutionContext;
    private final JPAApi jpaApi;
    private final String last;
    private final String first;
    private long shardSize;

    public Repository(DatabaseExecutionContext databaseExecutionContext, JPAApi jpaApi, Config config, long shardSize) {
        this.databaseExecutionContext = databaseExecutionContext;
        this.jpaApi = jpaApi;
        this.last = ((Integer)StreamEx.of((Collection)config.getConfig("jpa").entrySet()).map(Map.Entry::getKey).map(Integer::valueOf).max(Comparator.comparingInt(x -> x)).orElseThrow(() -> new ServiceException("JPA name not configured"))).toString();
        this.first = ((Integer)StreamEx.of((Collection)config.getConfig("jpa").entrySet()).map(Map.Entry::getKey).map(Integer::valueOf).min(Comparator.comparingInt(x -> x)).orElseThrow(() -> new ServiceException("JPA name not configured"))).toString();
        this.shardSize = shardSize;
    }

    private <T> T wrap(String db, Function<EntityManager, T> function) {
        return (T)this.jpaApi.withTransaction(db, function);
    }

    protected String findShard(long accountId) {
        return String.valueOf(accountId / this.shardSize + 1L);
    }

    protected <T> CompletableFuture<T> supplyAsync(Function<EntityManager, T> function, String qualifier) {
        return CompletableFuture.supplyAsync(() -> this.wrap(qualifier, function), (Executor)((Object)this.databaseExecutionContext));
    }

    protected <T> CompletableFuture<T> supplyAsync(Function<EntityManager, T> function, DBQualifier qualifier) {
        return CompletableFuture.supplyAsync(() -> this.wrap(this.getDBName(qualifier), function), (Executor)((Object)this.databaseExecutionContext));
    }

    private String getDBName(DBQualifier qualifier) {
        switch (qualifier) {
            case LAST: {
                return this.last;
            }
            case FIRST: {
                return this.first;
            }
        }
        throw new ServiceException("Unknown DBQualifier " + (Object)((Object)qualifier));
    }

    protected static enum DBQualifier {
        LAST,
        FIRST;

    }
}

