/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.vk.requests.auth;

import com.google.common.base.Preconditions;
import java.util.List;
import play.libs.ws.WS;
import play.libs.ws.WSRequestHolder;
import ru.quadcom.social.lib.vk.VK;
import ru.quadcom.social.lib.vk.VKApiVersion;
import ru.quadcom.social.lib.vk.requests.AbstractRequest;

public class ServerAppAuthGetAccessTokenRequestVK
extends AbstractRequest {
    protected final String url = VK.TOKEN_URL.url();
    protected final VKApiVersion apiVersion;
    protected final String clientId;
    protected final String applicationSecret;
    protected final String grantType;

    private ServerAppAuthGetAccessTokenRequestVK(String clientId, String applicationSecret, VKApiVersion apiVersion) {
        super(null, null);
        this.apiVersion = apiVersion;
        this.clientId = clientId;
        this.applicationSecret = applicationSecret;
        this.grantType = "client_credentials";
    }

    public static ServerAppAuthGetAccessTokenRequestVK request(String clientId, String applicationSecret) {
        Preconditions.checkArgument((clientId != null && !clientId.isEmpty() ? 1 : 0) != 0, (Object)"clientId null or empty");
        Preconditions.checkArgument((applicationSecret != null && !applicationSecret.isEmpty() ? 1 : 0) != 0, (Object)"applicationSecret null or empty");
        return new ServerAppAuthGetAccessTokenRequestVK(clientId, applicationSecret, VKApiVersion.DEFAULT);
    }

    public ServerAppAuthGetAccessTokenRequestVK withApiVersion(VKApiVersion apiVersion) {
        Preconditions.checkArgument((apiVersion != null ? 1 : 0) != 0, (Object)"apiVersion is null");
        return new ServerAppAuthGetAccessTokenRequestVK(this.clientId, this.applicationSecret, apiVersion);
    }

    public WSRequestHolder requestHolder() {
        WSRequestHolder requestHolder = WS.url((String)this.url);
        requestHolder = requestHolder.setQueryParameter("client_id", this.clientId);
        requestHolder = requestHolder.setQueryParameter("client_secret", this.applicationSecret);
        requestHolder = requestHolder.setQueryParameter("grant_type", this.grantType);
        requestHolder = requestHolder.setQueryParameter("v", this.apiVersion.asString());
        return requestHolder;
    }

    public String asArgumentToExecuteMethod() {
        throw new UnsupportedOperationException("Not supported");
    }

    public List transformExecuteResponseIntoResponseList(String partOfResponse) {
        throw new UnsupportedOperationException("Not supported");
    }
}

