/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.vk.requests.account;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import com.google.inject.Inject;
import java.util.Set;
import java.util.concurrent.Callable;
import ru.quadcom.social.lib.interfaces.IAccount;
import ru.quadcom.social.lib.interfaces.IClient;
import ru.quadcom.social.lib.vk.VKApiVersion;
import ru.quadcom.social.lib.vk.VKPermissions;
import ru.quadcom.social.lib.vk.requests.account.AccountGetAppPermissionsRequestVK;
import ru.quadcom.social.lib.vk.responses.account.GetAppPermissionsResponseVK;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccountHelperVK
implements IAccount {
    private final ExecutionContext executionContext;
    private final IClient vkClient;

    @Inject
    public AccountHelperVK(IClient vkClient) {
        this.vkClient = vkClient;
        this.executionContext = vkClient.getExecutionContext();
    }

    @Override
    public Future<Set<VKPermissions>> getAppPermissions(String accessToken, VKApiVersion apiVersion) {
        AccountGetAppPermissionsRequestVK requestVK = AccountGetAppPermissionsRequestVK.request(accessToken);
        requestVK = requestVK.withApiVersion(apiVersion);
        return this.appPermissions(requestVK, apiVersion);
    }

    @Override
    public Future<Set<VKPermissions>> getAppPermissions(String accessToken) {
        AccountGetAppPermissionsRequestVK requestVK = AccountGetAppPermissionsRequestVK.request(accessToken);
        requestVK = requestVK.withApiVersion(VKApiVersion.DEFAULT);
        return this.appPermissions(requestVK, VKApiVersion.DEFAULT);
    }

    private Future<Set<VKPermissions>> appPermissions(AccountGetAppPermissionsRequestVK requestVK, VKApiVersion apiVersion) {
        Future<GetAppPermissionsResponseVK> responseVKFuture = this.vkClient.makeRequestAndMapResponse(requestVK, apiVersion, GetAppPermissionsResponseVK.class);
        Future vkPermissionSet = responseVKFuture.flatMap((Function1)new Mapper<GetAppPermissionsResponseVK, Future<Set<VKPermissions>>>(){

            public Future<Set<VKPermissions>> apply(final GetAppPermissionsResponseVK permissionsResponseVK) {
                return Futures.future((Callable)new Callable<Set<VKPermissions>>(){

                    @Override
                    public Set<VKPermissions> call() throws Exception {
                        return VKPermissions.permissionsByMask(permissionsResponseVK.mask());
                    }
                }, (ExecutionContext)AccountHelperVK.this.executionContext);
            }
        }, this.executionContext);
        return vkPermissionSet;
    }
}

