/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.vk.exceptions;

import com.google.gson.Gson;
import ru.quadcom.social.lib.vk.exceptions.ApplicationDisabledVK;
import ru.quadcom.social.lib.vk.exceptions.AuthExceptionVK;
import ru.quadcom.social.lib.vk.exceptions.BaseExceptionVK;
import ru.quadcom.social.lib.vk.exceptions.IncorrectSignatureVK;
import ru.quadcom.social.lib.vk.exceptions.NoUserActivityLastMonthVK;
import ru.quadcom.social.lib.vk.exceptions.PermissionDeniedVK;
import ru.quadcom.social.lib.vk.exceptions.TooManyRequestPerSecondVK;
import ru.quadcom.social.lib.vk.exceptions.UnknownErrorVK;
import ru.quadcom.social.lib.vk.exceptions.UnknownMethodPassedVK;
import ru.quadcom.social.lib.vk.exceptions.UserAuthFailedVK;
import ru.quadcom.social.lib.vk.responses.objects.AuthErrorVK;
import ru.quadcom.social.lib.vk.responses.objects.ErrorVK;

public class ExceptionMapperVK {
    private static final Gson gson = new Gson();

    public static void throwVKException(String body) {
        ErrorVK errorVK = null;
        try {
            errorVK = (ErrorVK)gson.fromJson(body, ErrorVK.class);
        }
        catch (Throwable throwable) {
            AuthErrorVK authErrorVK = (AuthErrorVK)gson.fromJson(body, AuthErrorVK.class);
            throw new AuthExceptionVK(authErrorVK.getError_description());
        }
        switch (errorVK.errorCode()) {
            case 1: {
                throw new UnknownErrorVK();
            }
            case 2: {
                throw new ApplicationDisabledVK();
            }
            case 3: {
                throw new UnknownMethodPassedVK();
            }
            case 4: {
                throw new IncorrectSignatureVK();
            }
            case 5: {
                throw new UserAuthFailedVK();
            }
            case 6: {
                throw new TooManyRequestPerSecondVK();
            }
            case 7: {
                throw new PermissionDeniedVK();
            }
            case 15: {
                throw new NoUserActivityLastMonthVK();
            }
        }
        throw new BaseExceptionVK(errorVK.errorCode(), errorVK.errorMsg());
    }
}

