/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.ok.requests.notifications;

import com.google.common.base.Preconditions;
import org.joda.time.DateTime;
import org.springframework.security.authentication.encoding.Md5PasswordEncoder;
import play.libs.ws.WSRequestHolder;
import ru.quadcom.social.lib.ok.OK;
import ru.quadcom.social.lib.ok.requests.AbstractApplicationOkRequest;
import ru.quadcom.social.lib.ok.utils.TimeDateFormatter;

public class NotificationsSendMassRequestOk
extends AbstractApplicationOkRequest {
    protected final String url = OK.APP_URL.url() + "/notifications/sendMass";
    protected final String text;
    protected final String expires;

    public static NotificationsSendMassRequestOk request(String applicationKey, String applicationSecret, String text, DateTime expires) {
        Preconditions.checkArgument((applicationKey != null && !applicationKey.isEmpty() ? 1 : 0) != 0, (Object)"applicationKey is null or empty");
        Preconditions.checkArgument((applicationSecret != null && !applicationSecret.isEmpty() ? 1 : 0) != 0, (Object)"applicationSecret is null or empty");
        Preconditions.checkArgument((text != null && !text.isEmpty() ? 1 : 0) != 0, (Object)"text is null or empty");
        Preconditions.checkArgument((expires != null ? 1 : 0) != 0, (Object)"expires is null");
        return new NotificationsSendMassRequestOk(applicationKey, applicationSecret, text, expires);
    }

    private NotificationsSendMassRequestOk(String applicationKey, String applicationSecret, String text, DateTime expires) {
        super(applicationKey, applicationSecret);
        this.text = text;
        this.expires = TimeDateFormatter.print(expires);
    }

    public WSRequestHolder requestHolder() {
        WSRequestHolder requestHolder = this.baseRequest(this.url);
        requestHolder = requestHolder.setQueryParameter("text", this.text);
        requestHolder = requestHolder.setQueryParameter("expires", this.expires);
        requestHolder = requestHolder.setQueryParameter("method", "notifications.sendMass");
        return requestHolder;
    }

    protected String signature() {
        StringBuilder params = new StringBuilder();
        params.append("application_key").append('=').append(this.applicationKey);
        params.append("expires").append('=').append(this.expires);
        params.append("method").append('=').append("notifications.sendMass");
        params.append("text").append('=').append(this.text);
        params.append(this.applicationSecret);
        String sig = new Md5PasswordEncoder().encodePassword(params.toString(), null).toLowerCase();
        return sig;
    }
}

