/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.ok.client;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.ws.WSResponse;
import ru.quadcom.social.lib.ok.exceptions.ExceptionMapperOk;
import ru.quadcom.social.lib.ok.interfaces.IOkAppClient;
import ru.quadcom.social.lib.ok.requests.AbstractApplicationOkRequest;
import ru.quadcom.social.lib.ok.responses.objects.ErrorOk;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OkAppClient
implements IOkAppClient {
    private static final Logger logger = LoggerFactory.getLogger(OkAppClient.class);
    private static final Gson gson = new Gson();
    private final ExecutionContext executionContext;

    public OkAppClient(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Override
    public <T> Future<T> makeRequestAndMapResponse(AbstractApplicationOkRequest request, final Class<T> clazz) {
        Future<String> responseFuture = this.makeRequest(request);
        Future responseOkFuture = responseFuture.flatMap((Function1)new Mapper<String, Future<T>>(){

            public Future<T> apply(final String responseBody) {
                return Futures.future((Callable)new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        Object responseOk = gson.fromJson(responseBody, clazz);
                        logger.info("After mapping : " + responseOk);
                        return responseOk;
                    }
                }, (ExecutionContext)OkAppClient.this.executionContext);
            }
        }, this.executionContext);
        return responseOkFuture;
    }

    private Future<String> makeRequest(AbstractApplicationOkRequest abstractRequestOk) {
        logger.info("makeRequest()");
        Future<Map<String, Object>> responseStringFuture = this.futureResponse(abstractRequestOk, this.executionContext);
        return responseStringFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<String>>(){

            public Future<String> apply(final Map<String, Object> resultMap) {
                return Futures.future((Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        int statusCode = (Integer)resultMap.get("STATUS");
                        String responseBody = (String)resultMap.get("RESULT");
                        logger.info("makeRequest() : receive response : " + responseBody + " statusCode : " + statusCode);
                        if (responseBody.contains("\"error_code\"")) {
                            ExceptionMapperOk.throwOkException(responseBody);
                        }
                        return responseBody;
                    }
                }, (ExecutionContext)OkAppClient.this.executionContext);
            }
        }, this.executionContext);
    }

    private Future<Map<String, Object>> futureResponse(final AbstractApplicationOkRequest abstractRequestOK, final ExecutionContext executionContext) {
        Future firstTryFuture = abstractRequestOK.requestHolder().get().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final WSResponse firstResponse) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        ErrorOk errorOk;
                        HashMap<String, Object> result = new HashMap<String, Object>();
                        int statusCode = firstResponse.getStatus();
                        result.put("STATUS", statusCode);
                        String responseBody = firstResponse.getBody();
                        if (responseBody.contains("\"error_code\"") && ((errorOk = (ErrorOk)gson.fromJson(responseBody, ErrorOk.class)).getError_code() == 2 || errorOk.getError_code() == 11)) {
                            logger.warn("futureResponse() : first try " + abstractRequestOK.url() + " : Service temporarily unavailable or Reached the limit of method calls : retry after one sec");
                            result.put("RETRY", Boolean.TRUE);
                            result.put("TIME", System.currentTimeMillis());
                            return result;
                        }
                        logger.warn("futureResponse() : first try : don't retry return result");
                        result.put("RETRY", Boolean.FALSE);
                        result.put("RESULT", responseBody);
                        return result;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
        Future secondTryFuture = firstTryFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Map<String, Object> firstTryResultMap) {
                if (((Boolean)firstTryResultMap.get("RETRY")).booleanValue()) {
                    Long time = (Long)firstTryResultMap.get("TIME");
                    long currentTime = System.currentTimeMillis();
                    long howManyToOneSecWait = 1000L - (currentTime - time);
                    if (howManyToOneSecWait > 0L) {
                        try {
                            logger.warn("futureResponse() : second try : start waiting for " + howManyToOneSecWait + " sec in " + System.currentTimeMillis());
                            Thread.currentThread();
                            Thread.sleep(howManyToOneSecWait);
                            logger.warn("futureResponse() : second try : finish waiting in " + System.currentTimeMillis());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return abstractRequestOK.requestHolder().get().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<Map<String, Object>>>(){

                        public Future<Map<String, Object>> apply(final WSResponse secondResponse) {
                            return Futures.future((Callable)new Callable<Map<String, Object>>(){

                                @Override
                                public Map<String, Object> call() throws Exception {
                                    ErrorOk errorOk;
                                    HashMap<String, Object> result = new HashMap<String, Object>();
                                    int statusCode = secondResponse.getStatus();
                                    result.put("STATUS", statusCode);
                                    String responseBody = secondResponse.getBody();
                                    if (responseBody.contains("\"error_code\"") && ((errorOk = (ErrorOk)gson.fromJson(responseBody, ErrorOk.class)).getError_code() == 2 || errorOk.getError_code() == 11)) {
                                        logger.warn("futureResponse() : second try " + abstractRequestOK.url() + " : Service temporarily unavailable or Reached the limit of method calls : retry after one sec");
                                        result.put("RETRY", Boolean.TRUE);
                                        result.put("TIME", System.currentTimeMillis());
                                        return result;
                                    }
                                    logger.warn("futureResponse() : second try : don't retry return result");
                                    result.put("RETRY", Boolean.FALSE);
                                    result.put("RESULT", responseBody);
                                    return result;
                                }
                            }, (ExecutionContext)executionContext);
                        }
                    }, executionContext);
                }
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        return firstTryResultMap;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
        Future thirdTryFuture = secondTryFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Map<String, Object> secondTryResultMap) {
                if (((Boolean)secondTryResultMap.get("RETRY")).booleanValue()) {
                    Long time = (Long)secondTryResultMap.get("TIME");
                    long currentTime = System.currentTimeMillis();
                    long howManyToOneSecWait = 2000L - (currentTime - time);
                    if (howManyToOneSecWait > 0L) {
                        try {
                            logger.warn("futureResponse() : third try : start waiting for " + howManyToOneSecWait + " sec in " + System.currentTimeMillis());
                            Thread.currentThread();
                            Thread.sleep(howManyToOneSecWait);
                            logger.warn("futureResponse() : third try : finish waiting in " + System.currentTimeMillis());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return abstractRequestOK.requestHolder().get().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<Map<String, Object>>>(){

                        public Future<Map<String, Object>> apply(final WSResponse thirdResponse) {
                            return Futures.future((Callable)new Callable<Map<String, Object>>(){

                                @Override
                                public Map<String, Object> call() throws Exception {
                                    HashMap<String, Object> result = new HashMap<String, Object>();
                                    String responseBody = thirdResponse.getBody();
                                    result.put("STATUS", thirdResponse.getStatus());
                                    result.put("RETRY", Boolean.FALSE);
                                    result.put("RESULT", responseBody);
                                    logger.warn("futureResponse() : third try : return any result");
                                    return result;
                                }
                            }, (ExecutionContext)executionContext);
                        }
                    }, executionContext);
                }
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        return secondTryResultMap;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
        return thirdTryFuture;
    }
}

