/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.my.requests.notifications;

import com.google.common.base.Preconditions;
import org.springframework.security.authentication.encoding.Md5PasswordEncoder;
import play.libs.ws.WSRequestHolder;
import ru.quadcom.social.lib.my.requests.AbstractApplicationMyRequest;

public class NotificationsSendRequestMy
extends AbstractApplicationMyRequest {
    protected final String uids;
    protected final String text;

    public static NotificationsSendRequestMy request(Integer appId, String secretKey, String uids, String text) {
        Preconditions.checkArgument((appId != null ? 1 : 0) != 0, (Object)"appId is null");
        Preconditions.checkArgument((secretKey != null && !secretKey.isEmpty() ? 1 : 0) != 0, (Object)"secretKey is null or empty");
        Preconditions.checkArgument((uids != null && !uids.isEmpty() ? 1 : 0) != 0, (Object)"uids is null or empty");
        Preconditions.checkArgument((text != null && !text.isEmpty() ? 1 : 0) != 0, (Object)"text is null or empty");
        return new NotificationsSendRequestMy(appId, secretKey, uids, text);
    }

    private NotificationsSendRequestMy(int appId, String secretKey, String uids, String text) {
        super("notifications.send", appId, secretKey);
        this.uids = uids;
        this.text = text;
    }

    public WSRequestHolder requestHolder() {
        WSRequestHolder requestHolder = this.baseRequest();
        requestHolder = requestHolder.setQueryParameter("text", this.text);
        requestHolder = requestHolder.setQueryParameter("uids", this.uids);
        return requestHolder;
    }

    protected String signature() {
        StringBuilder params = new StringBuilder();
        params.append("app_id").append('=').append(this.appId);
        params.append("method").append('=').append("notifications.send");
        params.append("secure").append('=').append("1");
        params.append("text").append('=').append(this.text);
        params.append("uids").append('=').append(this.uids);
        params.append(this.secretKey);
        String sig = new Md5PasswordEncoder().encodePassword(params.toString(), null).toLowerCase();
        return sig;
    }
}

