/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.my.requests.notifications;

import com.google.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.quadcom.social.lib.my.interfaces.IMyAppClient;
import ru.quadcom.social.lib.my.interfaces.IMyNotifications;
import ru.quadcom.social.lib.my.requests.notifications.NotificationsSendRequestMy;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationsHelperMy
implements IMyNotifications {
    private static final Logger logger = LoggerFactory.getLogger(NotificationsHelperMy.class);
    private final ExecutionContext executionContext;
    private final IMyAppClient appClient;

    @Inject
    public NotificationsHelperMy(IMyAppClient appClient) {
        this.executionContext = appClient.getExecutionContext();
        this.appClient = appClient;
    }

    @Override
    public Future<String> send(Integer appId, String secretKey, String uids, String text) {
        logger.debug("send : appId : [{}], secret key : [{}], uids : [{}], text : [{}]", new Object[]{appId, secretKey, uids, text});
        NotificationsSendRequestMy requestMy = NotificationsSendRequestMy.request(appId, secretKey, uids, text);
        return this.appClient.makeRequestAndMapResponse(requestMy, String.class);
    }
}

