/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.vk.requests.users;

import com.google.common.base.Preconditions;
import java.util.List;
import play.libs.ws.WSRequestHolder;
import ru.quadcom.social.lib.vk.VK;
import ru.quadcom.social.lib.vk.VKApiVersion;
import ru.quadcom.social.lib.vk.requests.AbstractRequest;

public class UsersIsAppUserRequestVK
extends AbstractRequest {
    protected final String url = VK.GRAPH_HOST.url().concat("/users.isAppUser");
    protected final Long userId;

    public static UsersIsAppUserRequestVK request(String accessToken) {
        Preconditions.checkArgument((accessToken != null && !accessToken.isEmpty() ? 1 : 0) != 0, (Object)"accessToken is null or empty");
        return new UsersIsAppUserRequestVK(VKApiVersion.DEFAULT, accessToken, null);
    }

    private UsersIsAppUserRequestVK(VKApiVersion apiVersion, String accessToken, Long userId) {
        super(apiVersion, accessToken);
        this.userId = userId;
    }

    public UsersIsAppUserRequestVK withApiVersion(VKApiVersion apiVersion) {
        return new UsersIsAppUserRequestVK(apiVersion, this.accessToken, this.userId);
    }

    public UsersIsAppUserRequestVK withUserId(Long userId) {
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"userId is null or empty");
        Preconditions.checkArgument((userId > 0L ? 1 : 0) != 0, (Object)"userId < 0");
        return new UsersIsAppUserRequestVK(this.apiVersion, this.accessToken, userId);
    }

    public WSRequestHolder requestHolder() {
        WSRequestHolder requestHolder = this.baseRequest(this.url);
        if (this.userId != null) {
            requestHolder = requestHolder.setQueryParameter("user_id", this.userId.toString());
        }
        return requestHolder;
    }

    public String asArgumentToExecuteMethod() {
        StringBuilder stringBuilder = new StringBuilder("API.users.isAppUser(");
        if (this.userId != null) {
            stringBuilder.append("{\"user_id\":\"");
            stringBuilder.append(this.userId.toString());
            stringBuilder.append("\"");
            stringBuilder.append("}");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public List transformExecuteResponseIntoResponseList(String partOfResponse) {
        throw new UnsupportedOperationException("Not supported");
    }
}

