/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.vk.requests.users;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import com.google.inject.Inject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.quadcom.social.lib.interfaces.IClient;
import ru.quadcom.social.lib.interfaces.IUser;
import ru.quadcom.social.lib.vk.VKApiVersion;
import ru.quadcom.social.lib.vk.requests.users.UsersGetRequestVK;
import ru.quadcom.social.lib.vk.requests.users.UsersIsAppUserRequestVK;
import ru.quadcom.social.lib.vk.responses.objects.UserVK;
import ru.quadcom.social.lib.vk.responses.users.UsersGetResponseVK;
import ru.quadcom.social.lib.vk.responses.users.UsersIsAppUserResponseVK;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsersHelperVK
implements IUser {
    private static final Logger logger = LoggerFactory.getLogger(UsersHelperVK.class);
    private final ExecutionContext executionContext;
    private final IClient vkClient;

    @Inject
    public UsersHelperVK(IClient vkClient) {
        this.vkClient = vkClient;
        this.executionContext = vkClient.getExecutionContext();
    }

    @Override
    public Future<Boolean> isAppUser(String accessToken) {
        return this.isAppUser(accessToken, VKApiVersion.DEFAULT);
    }

    @Override
    public Future<Boolean> isAppUser(String accessToken, VKApiVersion apiVersion) {
        UsersIsAppUserRequestVK requestVK = UsersIsAppUserRequestVK.request(accessToken);
        requestVK = requestVK.withApiVersion(apiVersion);
        return this.isAppUser(requestVK, apiVersion);
    }

    @Override
    public Future<Boolean> isAppUser(String accessToken, Long userId) {
        return this.isAppUser(accessToken, userId, VKApiVersion.DEFAULT);
    }

    @Override
    public Future<Boolean> isAppUser(String accessToken, Long userId, VKApiVersion apiVersion) {
        UsersIsAppUserRequestVK requestVK = UsersIsAppUserRequestVK.request(accessToken);
        requestVK = requestVK.withUserId(userId);
        requestVK = requestVK.withApiVersion(apiVersion);
        return this.isAppUser(requestVK, apiVersion);
    }

    private Future<Boolean> isAppUser(UsersIsAppUserRequestVK usersIsAppUserRequestVK, VKApiVersion apiVersion) {
        Future<UsersIsAppUserResponseVK> usersIsAppUserResponseVKFuture = this.vkClient.makeRequestAndMapResponse(usersIsAppUserRequestVK, apiVersion, UsersIsAppUserResponseVK.class);
        return usersIsAppUserResponseVKFuture.flatMap((Function1)new Mapper<UsersIsAppUserResponseVK, Future<Boolean>>(){

            public Future<Boolean> apply(final UsersIsAppUserResponseVK responseVK) {
                return Futures.future((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return responseVK.isAppUser();
                    }
                }, (ExecutionContext)UsersHelperVK.this.executionContext);
            }
        }, this.executionContext);
    }

    @Override
    public Future<List<UserVK>> get(String accessToken) {
        return this.get(accessToken, VKApiVersion.DEFAULT);
    }

    @Override
    public Future<List<UserVK>> get(String accessToken, VKApiVersion apiVersion) {
        UsersGetRequestVK requestVK = UsersGetRequestVK.request(accessToken);
        requestVK = requestVK.withFields(UsersGetRequestVK.Fields.all());
        requestVK = requestVK.withApiVersion(apiVersion);
        return this.usersGet(requestVK, apiVersion);
    }

    @Override
    public Future<List<UserVK>> get(String accessToken, Set<Long> userIds) {
        return this.get(accessToken, userIds, VKApiVersion.DEFAULT);
    }

    @Override
    public Future<List<UserVK>> get(String accessToken, Set<Long> userIds, VKApiVersion apiVersion) {
        UsersGetRequestVK requestVK = UsersGetRequestVK.request(accessToken);
        requestVK = requestVK.withFields(UsersGetRequestVK.Fields.all());
        requestVK = requestVK.withUserIds(userIds);
        requestVK = requestVK.withApiVersion(apiVersion);
        return this.usersGet(requestVK, apiVersion);
    }

    @Override
    public Future<List<UserVK>> get(String accessToken, Set<Long> userIds, Set<UsersGetRequestVK.Fields> fields) {
        return this.get(accessToken, userIds, fields, VKApiVersion.DEFAULT);
    }

    @Override
    public Future<List<UserVK>> get(String accessToken, Set<Long> userIds, Set<UsersGetRequestVK.Fields> fields, VKApiVersion apiVersion) {
        UsersGetRequestVK requestVK = UsersGetRequestVK.request(accessToken);
        if (userIds != null) {
            requestVK = requestVK.withUserIds(userIds);
        }
        requestVK = requestVK.withFields(fields);
        requestVK = requestVK.withApiVersion(apiVersion);
        return this.usersGet(requestVK, apiVersion);
    }

    private Future<List<UserVK>> usersGet(UsersGetRequestVK usersGetRequestVK, VKApiVersion apiVersion) {
        Future<UsersGetResponseVK> usersGetResponseVKFuture = this.vkClient.makeRequestAndMapResponse(usersGetRequestVK, apiVersion, UsersGetResponseVK.class);
        return usersGetResponseVKFuture.flatMap((Function1)new Mapper<UsersGetResponseVK, Future<List<UserVK>>>(){

            public Future<List<UserVK>> apply(final UsersGetResponseVK response) {
                return Futures.future((Callable)new Callable<List<UserVK>>(){

                    @Override
                    public List<UserVK> call() throws Exception {
                        return response.users();
                    }
                }, (ExecutionContext)UsersHelperVK.this.executionContext);
            }
        }, this.executionContext);
    }
}

