/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.vk.requests;

import java.util.Collection;
import java.util.List;
import play.libs.ws.WS;
import play.libs.ws.WSRequestHolder;
import ru.quadcom.social.lib.vk.VKApiVersion;

public abstract class AbstractRequest {
    protected VKApiVersion apiVersion;
    protected String accessToken;

    protected AbstractRequest(VKApiVersion apiVersion, String accessToken) {
        this.apiVersion = apiVersion;
        this.accessToken = accessToken;
    }

    public String url() {
        return this.requestHolder().getUrl();
    }

    public abstract WSRequestHolder requestHolder();

    public WSRequestHolder baseRequest(String baseUrl) {
        WSRequestHolder requestHolder = WS.url((String)baseUrl);
        if (this.accessToken != null) {
            requestHolder = requestHolder.setQueryParameter("access_token", this.accessToken);
        }
        requestHolder = requestHolder.setQueryParameter("v", this.apiVersion.asString());
        return requestHolder;
    }

    public VKApiVersion api() {
        return this.apiVersion;
    }

    public String accessToken() {
        return this.accessToken;
    }

    protected String collectionAsStringWithComaSeparator(Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        int size = collection.size();
        int currentIndex = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (Object each : collection) {
            stringBuilder.append(each.toString());
            if (++currentIndex >= size) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    public abstract String asArgumentToExecuteMethod();

    public abstract List transformExecuteResponseIntoResponseList(String var1);
}

