/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.vk.client;

import akka.dispatch.Futures;
import akka.dispatch.Mapper;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.ws.WS;
import play.libs.ws.WSRequestHolder;
import play.libs.ws.WSResponse;
import ru.quadcom.social.lib.interfaces.IClient;
import ru.quadcom.social.lib.vk.VK;
import ru.quadcom.social.lib.vk.VKApiVersion;
import ru.quadcom.social.lib.vk.exceptions.ExceptionMapper;
import ru.quadcom.social.lib.vk.requests.AbstractRequest;
import ru.quadcom.social.lib.vk.requests.friends.FriendsGetRequestVK;
import ru.quadcom.social.lib.vk.responses.account.GetCountersResponseVK;
import ru.quadcom.social.lib.vk.responses.objects.ErrorVK;
import scala.Function1;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VKClient
implements IClient {
    private static final Logger logger = LoggerFactory.getLogger(VKClient.class);
    private static final Gson gson = new Gson();
    private final ExecutionContext executionContext;

    public VKClient(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Override
    public <T> Future<T> makeRequestAndMapResponse(AbstractRequest request, final VKApiVersion version, final Class<T> clazz) {
        Future<String> responseFuture = this.makeRequest(request);
        Future responseVKFuture = responseFuture.flatMap((Function1)new Mapper<String, Future<T>>(){

            public Future<T> apply(final String responseBody) {
                return Futures.future((Callable)new Callable<T>(){

                    @Override
                    public T call() throws Exception {
                        switch (version) {
                            case DEFAULT: {
                                logger.info("Try to map body : " + responseBody + " to " + clazz.getName());
                                if (clazz.equals(GetCountersResponseVK.class) && responseBody.equals("{\"response\":[]}")) {
                                    return new GetCountersResponseVK();
                                }
                                Object responseVK = gson.fromJson(responseBody, clazz);
                                logger.info("After mapping : " + responseVK);
                                return responseVK;
                            }
                            case FIVE_SIXTEEN: {
                                logger.info("Try to map body : " + responseBody + " to " + clazz.getName());
                                if (clazz.equals(GetCountersResponseVK.class) && responseBody.equals("{\"response\":[]}")) {
                                    return new GetCountersResponseVK();
                                }
                                Object responseVK = gson.fromJson(responseBody, clazz);
                                logger.info("After mapping : " + responseVK);
                                return responseVK;
                            }
                        }
                        throw new IllegalArgumentException("Wrong API Version : " + (Object)((Object)version));
                    }
                }, (ExecutionContext)VKClient.this.executionContext);
            }
        }, this.executionContext);
        return responseVKFuture;
    }

    private Future<String> makeRequest(AbstractRequest abstractRequestVK) {
        logger.info("makeRequest()");
        Future<Map<String, Object>> responseStringFuture = this.futureResponse(abstractRequestVK, this.executionContext);
        return responseStringFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<String>>(){

            public Future<String> apply(final Map<String, Object> resultMap) {
                return Futures.future((Callable)new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        int statusCode = (Integer)resultMap.get("STATUS");
                        String responseBody = (String)resultMap.get("RESULT");
                        logger.info("makeRequest() : receive response : " + responseBody + " statusCode : " + statusCode);
                        if (statusCode != 200 || responseBody.contains("\"error\"")) {
                            ExceptionMapper.throwVKException(responseBody);
                        }
                        return responseBody;
                    }
                }, (ExecutionContext)VKClient.this.executionContext);
            }
        }, this.executionContext);
    }

    private Future<Map<String, Object>> futureResponse(final AbstractRequest abstractRequestVK, final ExecutionContext executionContext) {
        Future firstTryFuture = abstractRequestVK.requestHolder().get().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final WSResponse firstResponse) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        ErrorVK errorVK;
                        HashMap<String, Object> result = new HashMap<String, Object>();
                        int statusCode = firstResponse.getStatus();
                        result.put("STATUS", statusCode);
                        String responseBody = firstResponse.getBody();
                        if (responseBody.contains("\"error\"") && (errorVK = (ErrorVK)gson.fromJson(responseBody, ErrorVK.class)).errorCode() == 6) {
                            logger.warn("futureResponse() : first try " + abstractRequestVK.url() + " : Too many requests per second : retry after one sec");
                            result.put("RETRY", Boolean.TRUE);
                            result.put("TIME", System.currentTimeMillis());
                            return result;
                        }
                        logger.warn("futureResponse() : first try : don't retry return result");
                        result.put("RETRY", Boolean.FALSE);
                        result.put("RESULT", responseBody);
                        return result;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
        Future secondTryFuture = firstTryFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Map<String, Object> firstTryResultMap) {
                if (((Boolean)firstTryResultMap.get("RETRY")).booleanValue()) {
                    Long time = (Long)firstTryResultMap.get("TIME");
                    long currentTime = System.currentTimeMillis();
                    long howManyToOneSecWait = 1000L - (currentTime - time);
                    if (howManyToOneSecWait > 0L) {
                        try {
                            logger.warn("futureResponse() : second try : start waiting for " + howManyToOneSecWait + " sec in " + System.currentTimeMillis());
                            Thread.currentThread();
                            Thread.sleep(howManyToOneSecWait);
                            logger.warn("futureResponse() : second try : finish waiting in " + System.currentTimeMillis());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return abstractRequestVK.requestHolder().get().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<Map<String, Object>>>(){

                        public Future<Map<String, Object>> apply(final WSResponse secondResponse) {
                            return Futures.future((Callable)new Callable<Map<String, Object>>(){

                                @Override
                                public Map<String, Object> call() throws Exception {
                                    ErrorVK errorVK;
                                    HashMap<String, Object> result = new HashMap<String, Object>();
                                    int statusCode = secondResponse.getStatus();
                                    result.put("STATUS", statusCode);
                                    String responseBody = secondResponse.getBody();
                                    if (responseBody.contains("\"error\"") && (errorVK = (ErrorVK)gson.fromJson(responseBody, ErrorVK.class)).errorCode() == 6) {
                                        logger.warn("futureResponse() : second try " + abstractRequestVK.url() + " : Too many requests per second : retry after two sec");
                                        result.put("RETRY", Boolean.TRUE);
                                        result.put("TIME", System.currentTimeMillis());
                                        return result;
                                    }
                                    logger.warn("futureResponse() : second try : don't retry return result");
                                    result.put("RETRY", Boolean.FALSE);
                                    result.put("RESULT", responseBody);
                                    return result;
                                }
                            }, (ExecutionContext)executionContext);
                        }
                    }, executionContext);
                }
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        return firstTryResultMap;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
        Future thirdTryFuture = secondTryFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Map<String, Object> secondTryResultMap) {
                if (((Boolean)secondTryResultMap.get("RETRY")).booleanValue()) {
                    Long time = (Long)secondTryResultMap.get("TIME");
                    long currentTime = System.currentTimeMillis();
                    long howManyToOneSecWait = 2000L - (currentTime - time);
                    if (howManyToOneSecWait > 0L) {
                        try {
                            logger.warn("futureResponse() : third try : start waiting for " + howManyToOneSecWait + " sec in " + System.currentTimeMillis());
                            Thread.currentThread();
                            Thread.sleep(howManyToOneSecWait);
                            logger.warn("futureResponse() : third try : finish waiting in " + System.currentTimeMillis());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return abstractRequestVK.requestHolder().get().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<Map<String, Object>>>(){

                        public Future<Map<String, Object>> apply(final WSResponse thirdResponse) {
                            return Futures.future((Callable)new Callable<Map<String, Object>>(){

                                @Override
                                public Map<String, Object> call() throws Exception {
                                    HashMap<String, Object> result = new HashMap<String, Object>();
                                    String responseBody = thirdResponse.getBody();
                                    result.put("STATUS", thirdResponse.getStatus());
                                    result.put("RETRY", Boolean.FALSE);
                                    result.put("RESULT", responseBody);
                                    logger.warn("futureResponse() : third try : return any result");
                                    return result;
                                }
                            }, (ExecutionContext)executionContext);
                        }
                    }, executionContext);
                }
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        return secondTryResultMap;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
        return thirdTryFuture;
    }

    @Override
    public Future<List<List>> makeExecuteRequest(final List<AbstractRequest> requests, String accessToken, VKApiVersion apiVersion) {
        logger.info("makeExecuteRequest()");
        Future<Map<String, Object>> responseStringFuture = this.futureExecuteResponse(this.request(requests, accessToken, apiVersion), this.executionContext);
        return responseStringFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<List<List>>>(){

            public Future<List<List>> apply(final Map<String, Object> resultMap) {
                return Futures.future((Callable)new Callable<List<List>>(){

                    @Override
                    public List<List> call() throws Exception {
                        int statusCode = (Integer)resultMap.get("STATUS");
                        String responseBody = (String)resultMap.get("RESULT");
                        logger.info("makeExecuteRequest() : receive response : " + responseBody + " statusCode : " + statusCode);
                        if (statusCode != 200 || responseBody.contains("\"error\"")) {
                            ExceptionMapper.throwVKException(responseBody);
                        }
                        responseBody = responseBody.substring(13);
                        responseBody = responseBody.substring(0, responseBody.length() - 2);
                        String[] arr = responseBody.split("],");
                        for (int i = 0; i < arr.length - 1; ++i) {
                            String each = arr[i];
                            arr[i] = each.concat("]");
                        }
                        ArrayList<List> finalResultList = new ArrayList<List>();
                        AbstractRequest firstRequest = (AbstractRequest)requests.get(0);
                        for (String eachPartOfResponse : arr) {
                            List eachExecuteResult = firstRequest.transformExecuteResponseIntoResponseList(eachPartOfResponse);
                            finalResultList.add(eachExecuteResult);
                        }
                        if (firstRequest instanceof FriendsGetRequestVK) {
                            return (List)finalResultList.get(0);
                        }
                        return finalResultList;
                    }
                }, (ExecutionContext)VKClient.this.executionContext);
            }
        }, this.executionContext);
    }

    private WSRequestHolder request(List<AbstractRequest> requests, String accessToken, VKApiVersion apiVersion) {
        logger.info("request()");
        if (requests.size() > 24) {
            throw new IllegalArgumentException("Execute can perform less then 25 requests");
        }
        String url = VK.GRAPH_HOST.url().concat("/execute");
        StringBuilder code = new StringBuilder("return [");
        int index = 0;
        int size = requests.size();
        for (AbstractRequest each : requests) {
            code.append(each.asArgumentToExecuteMethod());
            if (++index >= size) continue;
            code.append(",");
        }
        code.append("];");
        WSRequestHolder requestHolder = WS.url((String)url);
        requestHolder = requestHolder.setQueryParameter("code", code.toString());
        requestHolder = requestHolder.setQueryParameter("access_token", accessToken);
        requestHolder = requestHolder.setQueryParameter("v", apiVersion.asString());
        return requestHolder;
    }

    private Future<Map<String, Object>> futureExecuteResponse(final WSRequestHolder requestHolder, final ExecutionContext executionContext) {
        Future firstTryFuture = requestHolder.get().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final WSResponse firstResponse) {
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        ErrorVK errorVK;
                        HashMap<String, Object> result = new HashMap<String, Object>();
                        int statusCode = firstResponse.getStatus();
                        result.put("STATUS", statusCode);
                        String responseBody = firstResponse.getBody();
                        if (responseBody.contains("\"error\"") && (errorVK = (ErrorVK)gson.fromJson(responseBody, ErrorVK.class)).errorCode() == 6) {
                            logger.warn("futureExecuteResponse() : first try : Too many requests per second : retry after one sec");
                            result.put("RETRY", Boolean.TRUE);
                            result.put("TIME", System.currentTimeMillis());
                            return result;
                        }
                        logger.info("futureExecuteResponse() : first try : don't retry and return result");
                        result.put("RETRY", Boolean.FALSE);
                        result.put("RESULT", responseBody);
                        return result;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
        Future secondTryFuture = firstTryFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Map<String, Object> firstTryResultMap) {
                if (((Boolean)firstTryResultMap.get("RETRY")).booleanValue()) {
                    Long time = (Long)firstTryResultMap.get("TIME");
                    long currentTime = System.currentTimeMillis();
                    long howManyToOneSecWait = 1000L - (currentTime - time);
                    if (howManyToOneSecWait > 0L) {
                        try {
                            logger.warn("futureExecuteResponse() : second try : start waiting for " + howManyToOneSecWait + " sec in " + System.currentTimeMillis());
                            Thread.currentThread();
                            Thread.sleep(howManyToOneSecWait);
                            logger.warn("futureExecuteResponse() : second try : finish waiting in " + System.currentTimeMillis());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return VKClient.this.wsRequestHolder(requestHolder).get().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<Map<String, Object>>>(){

                        public Future<Map<String, Object>> apply(final WSResponse secondResponse) {
                            return Futures.future((Callable)new Callable<Map<String, Object>>(){

                                @Override
                                public Map<String, Object> call() throws Exception {
                                    ErrorVK errorVK;
                                    HashMap<String, Object> result = new HashMap<String, Object>();
                                    int statusCode = secondResponse.getStatus();
                                    result.put("STATUS", statusCode);
                                    String responseBody = secondResponse.getBody();
                                    if (responseBody.contains("\"error\"") && (errorVK = (ErrorVK)gson.fromJson(responseBody, ErrorVK.class)).errorCode() == 6) {
                                        logger.warn("futureExecuteResponse() : second try  : Too many requests per second : retry after two sec");
                                        result.put("RETRY", Boolean.TRUE);
                                        result.put("TIME", System.currentTimeMillis());
                                        return result;
                                    }
                                    logger.info("futureExecuteResponse() : second try : don't retry and return result");
                                    result.put("RETRY", Boolean.FALSE);
                                    result.put("RESULT", responseBody);
                                    return result;
                                }
                            }, (ExecutionContext)executionContext);
                        }
                    }, executionContext);
                }
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        return firstTryResultMap;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
        Future thirdTryFuture = secondTryFuture.flatMap((Function1)new Mapper<Map<String, Object>, Future<Map<String, Object>>>(){

            public Future<Map<String, Object>> apply(final Map<String, Object> secondTryResultMap) {
                if (((Boolean)secondTryResultMap.get("RETRY")).booleanValue()) {
                    Long time = (Long)secondTryResultMap.get("TIME");
                    long currentTime = System.currentTimeMillis();
                    long howManyToOneSecWait = 2000L - (currentTime - time);
                    if (howManyToOneSecWait > 0L) {
                        try {
                            logger.warn("futureExecuteResponse() : third try : start waiting for " + howManyToOneSecWait + " sec in " + System.currentTimeMillis());
                            Thread.currentThread();
                            Thread.sleep(howManyToOneSecWait);
                            logger.warn("futureExecuteResponse() : third try : finish waiting in " + System.currentTimeMillis());
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    return VKClient.this.wsRequestHolder(requestHolder).get().wrapped().flatMap((Function1)new Mapper<WSResponse, Future<Map<String, Object>>>(){

                        public Future<Map<String, Object>> apply(final WSResponse thirdResponse) {
                            return Futures.future((Callable)new Callable<Map<String, Object>>(){

                                @Override
                                public Map<String, Object> call() throws Exception {
                                    HashMap<String, Object> result = new HashMap<String, Object>();
                                    String responseBody = thirdResponse.getBody();
                                    logger.warn("futureExecuteResponse() : second try  : Return any result");
                                    result.put("STATUS", thirdResponse.getStatus());
                                    result.put("RETRY", Boolean.FALSE);
                                    result.put("RESULT", responseBody);
                                    return result;
                                }
                            }, (ExecutionContext)executionContext);
                        }
                    }, executionContext);
                }
                return Futures.future((Callable)new Callable<Map<String, Object>>(){

                    @Override
                    public Map<String, Object> call() throws Exception {
                        return secondTryResultMap;
                    }
                }, (ExecutionContext)executionContext);
            }
        }, executionContext);
        return thirdTryFuture;
    }

    private WSRequestHolder wsRequestHolder(WSRequestHolder baseRequestHolder) {
        String url = baseRequestHolder.getUrl();
        Map queryParams = baseRequestHolder.getQueryParameters();
        WSRequestHolder resultRequestHolder = WS.url((String)url);
        if (queryParams != null && !queryParams.isEmpty()) {
            for (String eachParamName : queryParams.keySet()) {
                Collection values = (Collection)queryParams.get(eachParamName);
                for (String eachParamValue : values) {
                    resultRequestHolder = resultRequestHolder.setQueryParameter(eachParamName, eachParamValue);
                }
            }
        }
        return resultRequestHolder;
    }
}

