/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.social.lib.vk;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum VKPermissions {
    notify(1),
    friends(2),
    photos(4),
    audio(8),
    video(16),
    docs(131072),
    notes(2048),
    pages(128),
    status(1024),
    wall(8192),
    groups(262144),
    messages(4096),
    notifications(524288),
    stats(0x100000),
    ads(32768),
    offline(65536);

    private int intValue;

    private VKPermissions(int intValue) {
        this.intValue = intValue;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public static Set<VKPermissions> permissionsByMask(int mask) {
        HashSet<VKPermissions> permissionsSet = new HashSet<VKPermissions>();
        for (VKPermissions eachPermission : VKPermissions.values()) {
            if ((mask & eachPermission.intValue) <= 0) continue;
            permissionsSet.add(eachPermission);
        }
        return permissionsSet;
    }

    public static List<VKPermissions> allExcludeStandalone() {
        ArrayList<VKPermissions> list = new ArrayList<VKPermissions>();
        for (VKPermissions eachPermission : VKPermissions.values()) {
            if (eachPermission == wall || eachPermission == messages) continue;
            list.add(eachPermission);
        }
        return list;
    }
}

