/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.play.util.configuration.parsers;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import ru.quadcom.play.util.configuration.parsers.IConfigurationValueParser;

class SetParser<V>
implements IConfigurationValueParser<Set<V>> {
    private final String delimiter;
    private final IConfigurationValueParser<V> itemParser;
    private final V defaultItemValue;
    private final boolean allowNulls;

    SetParser(String delimiter, IConfigurationValueParser<V> itemParser, V defaultItemValue, boolean allowNulls) {
        this.delimiter = delimiter;
        this.itemParser = itemParser;
        this.defaultItemValue = defaultItemValue;
        this.allowNulls = allowNulls;
    }

    @Override
    public Set<V> parseValue(String value, Set<V> defaultValue) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        String[] split = value.split(this.delimiter);
        if (split == null || split.length == 0) {
            return Collections.emptySet();
        }
        LinkedHashSet<V> result = new LinkedHashSet<V>(split.length);
        for (String item : split) {
            V itemValue = this.itemParser.parseValue(item, this.defaultItemValue);
            if (!this.allowNulls && itemValue == null) continue;
            result.add(itemValue);
        }
        return result;
    }
}

