/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.play.util.configuration;

import akka.actor.ActorSystem;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.libs.Json;
import play.libs.ws.WSClient;
import ru.quadcom.play.util.configuration.ConfigurationCache;
import ru.quadcom.play.util.configuration.ConfigurationInvocationHandler;
import ru.quadcom.play.util.configuration.ConfigurationItemHolder;
import ru.quadcom.play.util.configuration.ConfigurationUpdater;
import ru.quadcom.play.util.model.configuration.Configuration;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;

public class ConfigurationUtil {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationUpdater.class);

    public ConfigurationItemHolder getConfigurationItem(@NotNull String itemName) {
        return new ConfigurationItemHolder(itemName, ConfigurationCache.INSTANCE);
    }

    public <C> C getConfigurationInterface(@NotNull String name, @NotNull Class<? extends C> configurationInterface) {
        ConfigurationInvocationHandler handler = new ConfigurationInvocationHandler(this.getConfigurationItem(name), configurationInterface);
        return (C)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{configurationInterface}, (InvocationHandler)handler);
    }

    public void scheduleConfigRefreshThread(long delayMs, long frequencyMs, String configServiceUpdateUrl, String application, String environment, WSClient wsClient, ActorSystem system) {
        FiniteDuration delay = FiniteDuration.create((long)delayMs, (TimeUnit)TimeUnit.MILLISECONDS);
        FiniteDuration interval = FiniteDuration.create((long)frequencyMs, (TimeUnit)TimeUnit.MILLISECONDS);
        ConfigurationUpdater updater = new ConfigurationUpdater(configServiceUpdateUrl, application, environment, wsClient);
        system.scheduler().schedule(delay, interval, (Runnable)updater, (ExecutionContext)system.dispatcher());
    }

    public void initConfiguration(String configServiceUrl, String application, String environment, boolean exitOnFailure, WSClient wsClient) {
        CompletionStage wsPromise = wsClient.url(configServiceUrl).addQueryParameter("app_name", application).addQueryParameter("env_name", environment).get();
        wsPromise.thenApplyAsync(wsResponse -> {
            if (wsResponse.getStatus() == 200) {
                return (Configuration)Json.fromJson((JsonNode)wsResponse.asJson(), Configuration.class);
            }
            throw new IllegalStateException("Unexpected response status on getting configuration " + wsResponse.getStatus());
        }).thenAccept(ConfigurationCache.INSTANCE::applyConfiguration).exceptionally(e -> {
            logger.error("Unexpected error on getting the configuration", e);
            if (exitOnFailure) {
                System.exit(1);
            }
            return null;
        });
    }
}

