/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.play.util.recover;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import play.api.PlayException;
import play.http.HttpEntity;
import play.mvc.Result;
import ru.quadcom.commons.exceptions.ServiceException;
import ru.quadcom.play.util.controllers.BaseController;

public class DefaultExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExceptionHandler.class);
    private static final int INTERNAL_SERVER_ERROR_CODE = 500;

    private DefaultExceptionHandler() {
    }

    public static Result handle(Throwable t, String origin) {
        if (t == null) {
            logger.error("SERVICE_EXCEPTION : UnknownServerError");
            return DefaultExceptionHandler.resultWithHeaders(500, origin, "", 0);
        }
        if (t instanceof PlayException && t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)t;
            int errorCode = serviceException.getDefaultHttpStatusCode();
            logger.error("SERVICE_EXCEPTION : ServiceException with error code : " + errorCode, (Throwable)serviceException);
            return DefaultExceptionHandler.resultWithHeaders(errorCode, origin, serviceException.getDescription(), serviceException.getLogicErrorCode());
        }
        logger.error("SERVICE_EXCEPTION : InternalServer error" + t, t);
        return DefaultExceptionHandler.resultWithHeaders(500, origin, "", 0);
    }

    private static Result resultWithHeaders(int errorCode, String origin, String description, int logicErrorCode) {
        String desc = String.format("{\"errorCode\":%d, \"description\":\"%s\"}", logicErrorCode, description);
        return BaseController.withHeaders(new Result(errorCode, HttpEntity.fromString((String)desc, (String)"utf-8")), BaseController.accessControlHeaders(origin));
    }
}

