/*
 * Decompiled with CFR 0.152.
 */
package ru.quadcom.play.util.controllers;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;
import org.joda.time.format.ISODateTimeFormat;
import play.libs.Json;
import play.mvc.Controller;
import play.mvc.Http;
import play.mvc.Result;
import ru.quadcom.commons.exceptions.MissingParameterException;
import ru.quadcom.commons.exceptions.TimeSyncException;
import ru.quadcom.commons.identity.ServiceToServiceToken;
import ru.quadcom.commons.identity.Token;
import ru.quadcom.play.util.RequestHelper;

public class BaseController
extends Controller {
    public static final String TOKEN = "token";
    public static final String SERVICE_TOKEN = "service_token";
    public static final String LOCALE = "locale";
    public static final String APPLICATION_NAME_HEADER = "X-Application-Name";
    public static final String REQUEST_SENT_TIME = "X-Request-Sent-Time";
    public static final String SESSION_ID_HEADER = "X-Session-Id";
    public static final String ALLOWED_HEADERS = "Accept, X-Access-Token, X-Application-Name, X-Request-Sent-Time, X-Session-Id";
    public static final String ALLOWED_METHODS = "GET, POST, OPTIONS";
    public static final String REQUEST_BODY = "requestBody";
    private static final int CLIENT_SERVER_TIME_DIFF = 3;

    public static void storeRequestBody(Map<String, String[]> reqBody) {
        Http.Context context = BaseController.ctx();
        context.args.put(REQUEST_BODY, reqBody);
    }

    public static Map<String, String[]> getRequestBody() {
        Map reqBody = null;
        if (BaseController.ctx().args.containsKey(REQUEST_BODY)) {
            reqBody = (Map)BaseController.ctx().args.get(REQUEST_BODY);
        }
        return reqBody;
    }

    public static Map<String, String[]> getAllRequestParameters() {
        return BaseController.getRequestParameters(BaseController.request());
    }

    private static Map<String, String[]> getRequestParameters(Http.Request request) {
        Map params;
        if ("GET".equals(request.method())) {
            params = request.queryString();
        } else {
            params = BaseController.getRequestBody();
            if (params == null || params.isEmpty()) {
                params = request.body().asFormUrlEncoded();
                if (params == null && request.body().asMultipartFormData() != null) {
                    params = request.body().asMultipartFormData().asFormUrlEncoded();
                }
                BaseController.storeRequestBody(params);
                if (params == null) {
                    throw new MissingParameterException("Missing request content type");
                }
            }
        }
        return params;
    }

    public static String getApplicationName() {
        return RequestHelper.parseHeader(APPLICATION_NAME_HEADER, BaseController.request());
    }

    public static String getSessionId() {
        return RequestHelper.parseHeader(SESSION_ID_HEADER, BaseController.request());
    }

    public static DateTime getSendTime() {
        DateTime clientTime = ISODateTimeFormat.dateTime().parseDateTime((String)Json.fromJson((JsonNode)Json.parse((String)RequestHelper.parseHeader(REQUEST_SENT_TIME, BaseController.request())), String.class));
        if (Seconds.secondsBetween((ReadableInstant)clientTime, (ReadableInstant)DateTime.now((DateTimeZone)DateTimeZone.UTC)).getSeconds() > 3) {
            throw new TimeSyncException();
        }
        return clientTime;
    }

    public static String getRequiredParameter(String paramName) {
        String[] params = BaseController.getRequestParameters(BaseController.request()).get(paramName);
        if (params != null && params.length > 0) {
            if (params[0].isEmpty()) {
                throw new MissingParameterException("Missing parameter " + paramName, null);
            }
            return params[0];
        }
        throw new MissingParameterException("Missing parameter " + paramName, null);
    }

    public static String getParameter(String paramName) {
        String[] params = BaseController.getRequestParameters(BaseController.request()).get(paramName);
        if (params != null && params.length > 0) {
            if (params[0].isEmpty()) {
                return null;
            }
            return params[0];
        }
        return null;
    }

    public static Token getToken() {
        Token token = null;
        if (BaseController.ctx().args.containsKey(TOKEN)) {
            token = (Token)BaseController.ctx().args.get(TOKEN);
        }
        return token;
    }

    public static ServiceToServiceToken getServiceToken() {
        ServiceToServiceToken token = null;
        if (BaseController.ctx().args.containsKey(SERVICE_TOKEN)) {
            token = (ServiceToServiceToken)BaseController.ctx().args.get(SERVICE_TOKEN);
        }
        return token;
    }

    public static String getLocale() {
        String locale = null;
        if (BaseController.ctx().args.containsKey(LOCALE)) {
            locale = (String)BaseController.ctx().args.get(LOCALE);
        }
        return locale;
    }

    public CompletableFuture<Result> options(String url) {
        String origin = RequestHelper.parseHeader("Origin", BaseController.request()) != null ? RequestHelper.parseHeader("Origin", BaseController.request()) : "*";
        return CompletableFuture.supplyAsync(() -> BaseController.withHeaders((Result)BaseController.ok(), BaseController.accessControlHeaders(origin)));
    }

    public static Result withHeaders(Result result, Map<String, String> headers) {
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            result = result.withHeader(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Map<String, String> accessControlHeaders(String origin) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Access-Control-Allow-Origin", origin);
        map.put("Access-Control-Allow-Methods", ALLOWED_METHODS);
        map.put("Access-Control-Allow-Origin", ALLOWED_HEADERS);
        map.put("Access-Control-Allow-Credentials", "true");
        return map;
    }
}

